/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.config.CommonServices;
import gw.fs.IFile;
import gw.lang.parser.ISource;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.StringSource;
import gw.lang.parser.expressions.ITypeVariableDefinition;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.ISourceFileHandle;
import java.io.File;
import java.util.Map;

public class StringSourceFileHandle
implements ISourceFileHandle {
    private String _source;
    private boolean _bTestResource;
    private ClassType _classType;
    private String _typeName;
    private String _strEnclosingType;
    private ITypeUsesMap _typeUsesMap;
    private Map<String, ITypeVariableDefinition> _capturedTypeVars;
    private int _iOffset;
    private int _iEnd;
    private IFile _file;
    private String _fileRef;
    private ISymbolTable _extSyms;

    public StringSourceFileHandle(String typeName, CharSequence source, boolean isTestResource, ClassType classType) {
        this(typeName, source, null, isTestResource, classType);
    }

    public StringSourceFileHandle(String typeName, CharSequence source, IFile strPath, boolean isTestResource, ClassType classType) {
        this._typeName = typeName;
        this._source = source != null ? source.toString() : null;
        this._bTestResource = isTestResource;
        this._classType = classType;
        this._file = strPath;
        this.assignFileRef();
    }

    private void assignFileRef() {
        if (this._file == null) {
            return;
        }
        String strFile = this.getFilePath().replace('/', File.separatorChar);
        int iIndex = strFile.lastIndexOf(File.separatorChar);
        if (iIndex >= 0) {
            strFile = strFile.substring(iIndex + 1);
        }
        this._fileRef = strFile;
    }

    protected String getRawSource() {
        return this._source;
    }

    protected void setRawSource(CharSequence source) {
        this._source = source.toString();
    }

    @Override
    public ISource getSource() {
        return new StringSource(this.getRawSource());
    }

    @Override
    public String getParentType() {
        return this._strEnclosingType;
    }

    public void setParentType(String strEnclosingType) {
        this._strEnclosingType = strEnclosingType;
    }

    @Override
    public String getNamespace() {
        return this.getTypeNamespace();
    }

    @Override
    public String getFilePath() {
        return this._file == null ? null : this._file.getPath().getPathString();
    }

    @Override
    public boolean isTestClass() {
        return this._bTestResource;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isStandardPath() {
        return false;
    }

    @Override
    public boolean isIncludeModulePath() {
        return false;
    }

    @Override
    public void cleanAfterCompile() {
        this._source = null;
    }

    @Override
    public ClassType getClassType() {
        return this._classType;
    }

    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public String getRelativeName() {
        if (this._typeName.lastIndexOf(46) == -1) {
            return this._typeName;
        }
        return this._typeName.substring(this._typeName.lastIndexOf(46) + 1);
    }

    @Override
    public String getTypeNamespace() {
        if (this._typeName.lastIndexOf(46) == -1) {
            return "";
        }
        return this._typeName.substring(0, this._typeName.lastIndexOf(46));
    }

    @Override
    public void setOffset(int iOffset) {
        this._iOffset = iOffset;
    }

    @Override
    public int getOffset() {
        return this._iOffset;
    }

    @Override
    public void setEnd(int iEnd) {
        this._iEnd = iEnd;
    }

    @Override
    public int getEnd() {
        return this._iEnd;
    }

    public void setFilePath(String filePath) {
        if (filePath != null) {
            this._file = CommonServices.getFileSystem().getIFile(new File(filePath));
            this.assignFileRef();
        }
    }

    @Override
    public String getFileName() {
        return this._fileRef;
    }

    @Override
    public IFile getFile() {
        return this._file;
    }

    public void setTypeUsesMap(ITypeUsesMap typeUsesMap) {
        this._typeUsesMap = typeUsesMap;
    }

    public ITypeUsesMap getTypeUsesMap() {
        return this._typeUsesMap;
    }

    public void setCapturedTypeVars(Map<String, ITypeVariableDefinition> capturedTypeVars) {
        this._capturedTypeVars = capturedTypeVars;
    }

    public Map<String, ITypeVariableDefinition> getCapturedTypeVars() {
        return this._capturedTypeVars;
    }

    public String toString() {
        return this._typeName;
    }

    public void setExternalSymbols(ISymbolTable extSyms) {
        this._extSyms = extSyms;
    }

    public ISymbolTable getExternalSymbols() {
        return this._extSyms;
    }
}

