/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.jar;

import gw.fs.IDirectory;
import gw.fs.IDirectoryUtil;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.fs.jar.IJarFileDirectory;
import gw.fs.jar.JarEntryFileImpl;
import gw.fs.jar.JarEntryResourceImpl;
import gw.fs.jar.JarFileDirectoryImpl;
import gw.lang.UnstableAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UnstableAPI
public class JarEntryDirectoryImpl
extends JarEntryResourceImpl
implements IJarFileDirectory {
    private Map<String, IResource> _resources = new HashMap<String, IResource>();
    private List<IDirectory> _childDirs = new ArrayList<IDirectory>();
    private List<IFile> _childFiles = new ArrayList<IFile>();

    public JarEntryDirectoryImpl(String name, IJarFileDirectory parent, JarFileDirectoryImpl jarFile) {
        super(name, parent, jarFile);
    }

    @Override
    public JarEntryDirectoryImpl getOrCreateDirectory(String relativeName) {
        JarEntryDirectoryImpl result = (JarEntryDirectoryImpl)this._resources.get(relativeName);
        if (result == null) {
            result = new JarEntryDirectoryImpl(relativeName, this, this._jarFile);
            this._resources.put(relativeName, result);
            this._childDirs.add(result);
        }
        return result;
    }

    @Override
    public JarEntryFileImpl getOrCreateFile(String relativeName) {
        JarEntryFileImpl result = (JarEntryFileImpl)this._resources.get(relativeName);
        if (result == null) {
            result = new JarEntryFileImpl(relativeName, this, this._jarFile);
            this._resources.put(relativeName, result);
            this._childFiles.add(result);
        }
        return result;
    }

    @Override
    public IDirectory dir(String relativePath) {
        return IDirectoryUtil.dir(this, relativePath);
    }

    @Override
    public IFile file(String path) {
        return IDirectoryUtil.file(this, path);
    }

    @Override
    public boolean mkdir() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends IDirectory> listDirs() {
        ArrayList<IDirectory> results = new ArrayList<IDirectory>();
        for (IDirectory child : this._childDirs) {
            if (!child.exists()) continue;
            results.add(child);
        }
        return results;
    }

    @Override
    public List<? extends IFile> listFiles() {
        ArrayList<IFile> results = new ArrayList<IFile>();
        for (IFile child : this._childFiles) {
            if (!child.exists()) continue;
            results.add(child);
        }
        return results;
    }

    @Override
    public String relativePath(IResource resource) {
        return IDirectoryUtil.relativePath(this, resource);
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public boolean hasChildFile(String path) {
        IFile childFile = this.file(path);
        return childFile != null && childFile.exists();
    }

    @Override
    public boolean isAdditional() {
        return false;
    }
}

