/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.init;

import gw.fs.IDirectory;
import gw.fs.IResource;
import gw.lang.Gosu;
import gw.lang.reflect.TypeSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import manifold.api.fs.jar.IJarFileDirectory;
import manifold.api.host.IManifoldHost;
import manifold.internal.host.RuntimeManifoldHost;
import manifold.internal.javac.JavaParser;

public class GosuRuntimeManifoldHost
extends RuntimeManifoldHost {
    private JavaParser _javaParser;

    public static GosuRuntimeManifoldHost get() {
        return (GosuRuntimeManifoldHost)RuntimeManifoldHost.get();
    }

    public ClassLoader getActualClassLoader() {
        return TypeSystem.getGosuClassLoader().getActualLoader();
    }

    public JavaParser getJavaParser() {
        return this._javaParser == null ? (this._javaParser = new JavaParser((IManifoldHost)this)) : this._javaParser;
    }

    public void init(List<File> sourcepath, List<File> classpath) {
        if (Gosu.bootstrapGosuWhenInitiatedViaClassfile()) {
            TypeSystem.pushModule(TypeSystem.getGlobalModule());
        }
        if (classpath.isEmpty()) {
            classpath = new ArrayList<File>();
        }
        classpath.addAll(this.removeNonFiles(TypeSystem.getGlobalModule().getJavaClassPath()));
        if (sourcepath.isEmpty()) {
            sourcepath = new ArrayList<File>();
        }
        sourcepath.addAll(this.removeNonFiles(TypeSystem.getGlobalModule().getSourcePath()));
        if (!sourcepath.isEmpty()) {
            this.initDirectly(sourcepath, classpath);
            return;
        }
        super.init(sourcepath, classpath);
    }

    protected List<manifold.api.fs.IDirectory> createDefaultClassPath() {
        return super.createDefaultClassPath().stream().filter(f -> !this.isIntelliJGeneratedClasspathJar((manifold.api.fs.IDirectory)f)).collect(Collectors.toList());
    }

    private List<File> removeNonFiles(List<IDirectory> dirs) {
        return dirs.stream().filter(IResource::isJavaFile).filter(e -> !this.isIntelliJGeneratedClasspathJar((IDirectory)e)).map(IResource::toJavaFile).collect(Collectors.toList());
    }

    private boolean isIntelliJGeneratedClasspathJar(IDirectory e) {
        if (e instanceof gw.fs.jar.IJarFileDirectory) {
            String name = e.getName();
            return name.startsWith("classpath") && Character.isDigit(name.charAt("classpath".length()));
        }
        return false;
    }

    private boolean isIntelliJGeneratedClasspathJar(manifold.api.fs.IDirectory e) {
        if (e instanceof IJarFileDirectory) {
            String name = e.getName();
            return name.startsWith("classpath") && Character.isDigit(name.charAt("classpath".length()));
        }
        return false;
    }
}

