/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.annotation;

import gw.lang.GosuShop;
import gw.lang.annotation.UsageTarget;
import gw.lang.parser.AnnotationUseSiteTarget;
import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.java.JavaTypes;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum UsageModifier {
    None,
    One,
    Many;


    public static UsageModifier getUsageModifier(UsageTarget targetType, IAnnotationInfo annotation) {
        return UsageModifier.getUsageModifier(null, targetType, annotation.getType(), annotation.getTarget());
    }

    public static UsageModifier getUsageModifier(IParsedElement pe, UsageTarget targetType, IType annotationType, AnnotationUseSiteTarget target) {
        UsageModifier modifier = null;
        ArrayList<IAnnotationInfo> usageInfos = UsageModifier.getExplicitUsageAnnotations(annotationType);
        if (usageInfos != null && usageInfos.size() > 0) {
            return UsageModifier.getUsageModifier(targetType, modifier, usageInfos);
        }
        if (JavaTypes.ANNOTATION().isAssignableFrom(annotationType)) {
            return UsageModifier.translateJavaElementTypeToUsageModifier(pe, targetType, annotationType, target);
        }
        return Many;
    }

    private static ArrayList<IAnnotationInfo> getExplicitUsageAnnotations(IType type) {
        List<IAnnotationInfo> usagesAnnotations;
        ArrayList<IAnnotationInfo> lst = new ArrayList<IAnnotationInfo>();
        List<IAnnotationInfo> usageAnnotations = type.getTypeInfo().getAnnotationsOfType(JavaTypes.ANNOTATION_USAGE());
        if (usageAnnotations != null) {
            lst.addAll(usageAnnotations);
        }
        if ((usagesAnnotations = type.getTypeInfo().getAnnotationsOfType(JavaTypes.ANNOTATION_USAGES())) != null) {
            for (IAnnotationInfo iAnnotationInfo : usagesAnnotations) {
                IAnnotationInfo[] values = (IAnnotationInfo[])GosuShop.getAnnotationFieldValueAsArray(iAnnotationInfo, "value");
                lst.addAll(Arrays.asList(values));
            }
        }
        return lst;
    }

    private static UsageModifier getUsageModifier(UsageTarget targetType, UsageModifier modifier, ArrayList<IAnnotationInfo> annotationInfos) {
        for (IAnnotationInfo usage : annotationInfos) {
            String target = (String)usage.getFieldValue("target");
            String usageModifier = (String)usage.getFieldValue("usageModifier");
            if (target.equals(UsageTarget.AllTarget.name()) && modifier == null) {
                modifier = UsageModifier.valueOf(usageModifier);
            }
            if (!target.equals(targetType.name())) continue;
            modifier = UsageModifier.valueOf(usageModifier);
        }
        if (modifier == null) {
            modifier = None;
        }
        return modifier;
    }

    private static UsageModifier translateJavaElementTypeToUsageModifier(IParsedElement pe, UsageTarget targetType, IType annotationType, AnnotationUseSiteTarget target) {
        String[] value;
        IAnnotationInfo targetAnnotation = annotationType.getTypeInfo().getAnnotation(TypeSystem.get(Target.class));
        boolean bRepeatable = annotationType.getTypeInfo().hasAnnotation(JavaTypes.REPEATABLE());
        if (targetAnnotation == null) {
            if (target != null) {
                if (!UsageModifier.targetAppliesToParsedElement(pe, target)) {
                    return None;
                }
                return Many;
            }
            return bRepeatable ? Many : One;
        }
        Object v = targetAnnotation.getFieldValue("value");
        if (v == null) {
            value = null;
        } else if (v.getClass().isArray()) {
            if (v instanceof String[]) {
                value = (String[])v;
            } else {
                ElementType[] elems = (ElementType[])v;
                value = new String[elems.length];
                for (int i = 0; i < elems.length; ++i) {
                    value[i] = elems[i].name();
                }
            }
        } else {
            value = v instanceof String ? new String[]{(String)v} : new String[]{((ElementType)((Object)v)).name()};
        }
        if (value == null || value.length == 0) {
            return bRepeatable ? Many : One;
        }
        for (String elementTypeConst : value) {
            if (elementTypeConst.equals(ElementType.CONSTRUCTOR.name()) && targetType == UsageTarget.ConstructorTarget || elementTypeConst.equals(ElementType.ANNOTATION_TYPE.name()) && targetType == UsageTarget.TypeTarget || elementTypeConst.equals(ElementType.TYPE.name()) && targetType == UsageTarget.TypeTarget || elementTypeConst.equals(ElementType.PARAMETER.name()) && targetType == UsageTarget.ParameterTarget) {
                return bRepeatable ? Many : One;
            }
            if (elementTypeConst.equals(ElementType.PARAMETER.name()) && targetType == UsageTarget.PropertyTarget) {
                if (target != null && !UsageModifier.targetAppliesToParsedElement(pe, target)) {
                    return None;
                }
                return Many;
            }
            if (elementTypeConst.equals(ElementType.FIELD.name()) && targetType == UsageTarget.PropertyTarget) {
                if (target != null && !UsageModifier.targetAppliesToParsedElement(pe, target)) {
                    return None;
                }
                return Many;
            }
            if (!elementTypeConst.equals(ElementType.METHOD.name()) || targetType != UsageTarget.MethodTarget && targetType != UsageTarget.PropertyTarget) continue;
            if (target != null) {
                if (targetType == UsageTarget.MethodTarget) {
                    return None;
                }
                if (!UsageModifier.targetAppliesToParsedElement(pe, target)) {
                    return None;
                }
                return Many;
            }
            return bRepeatable ? Many : One;
        }
        return None;
    }

    public static boolean targetAppliesToParsedElement(IParsedElement pe, AnnotationUseSiteTarget target) {
        if (target == null) {
            return true;
        }
        if (pe instanceof IVarStatement && ((IVarStatement)pe).hasProperty()) {
            IVarStatement varStmt = (IVarStatement)pe;
            IDynamicPropertySymbol property = varStmt.getProperty();
            switch (target) {
                case get: {
                    return property != null && property.getGetterDfs() != null;
                }
                case set: 
                case param: {
                    return property != null && property.getSetterDfs() != null;
                }
                case accessors: {
                    return property != null;
                }
                case field: {
                    return property != null && (property.getGetterDfs() != null && !property.getGetterDfs().isAbstract() || property.getSetterDfs() != null && !property.getSetterDfs().isAbstract());
                }
            }
        } else if (pe instanceof IFunctionStatement && pe.getGosuClass() instanceof IGosuEnhancement && !((IFunctionStatement)pe).getDynamicFunctionSymbol().isStatic()) {
            return target == AnnotationUseSiteTarget.receiver;
        }
        return false;
    }
}

