/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.lang.IIssue;
import gw.lang.IIssueContainer;
import gw.lang.gosuc.GosuIssue;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.exceptions.ParseResultsException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GosuIssueContainer
implements IIssueContainer {
    private final ParseResultsException _pe;
    private List<IIssue> _issues;

    public GosuIssueContainer(ParseResultsException pe) {
        this._pe = pe;
    }

    @Override
    public List<IIssue> getIssues() {
        if (this._issues == null) {
            ArrayList<IIssue> issues = new ArrayList<IIssue>();
            if (this._pe != null) {
                for (IParseIssue diagnostic : this._pe.getParseIssues()) {
                    GosuIssue issue = new GosuIssue(diagnostic);
                    issues.add(issue);
                }
            }
            this._issues = issues;
        }
        return this._issues;
    }

    @Override
    public List<IIssue> getWarnings() {
        return this.getIssues().stream().filter(issue -> issue.getKind() == IIssue.Kind.Warning).collect(Collectors.toList());
    }

    @Override
    public List<IIssue> getErrors() {
        return this.getIssues().stream().filter(issue -> issue.getKind() == IIssue.Kind.Error).collect(Collectors.toList());
    }

    @Override
    public boolean isEmpty() {
        return this.getIssues().isEmpty();
    }
}

