/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.lang.gosuc.GosucProjectParser;
import gw.lang.parser.IToken;
import java.io.Serializable;

public class GosucDependency
implements Serializable {
    private String _modName;
    private boolean _exported;

    public GosucDependency(String modName, boolean exported) {
        this._exported = exported;
        this._modName = modName;
    }

    public String getModuleName() {
        return this._modName;
    }

    public boolean isExported() {
        return this._exported;
    }

    public String write() {
        StringBuilder out = new StringBuilder();
        out.append(this._modName);
        if (this._exported) {
            out.append(": exported");
        }
        return out.toString();
    }

    public static GosucDependency parse(GosucProjectParser parser) {
        IToken t = parser.getTokenizer().getCurrentToken();
        parser.verify(parser.match(null, -5, false), "Expecting module name for dependency");
        String name = t.getStringValue();
        boolean exported = false;
        if (parser.matchOperator(":", false)) {
            exported = parser.matchWord("exported", false);
            parser.verify(exported, "Expecting 'exported' keyword");
        }
        return new GosucDependency(name, exported);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GosucDependency that = (GosucDependency)o;
        if (this._exported != that._exported) {
            return false;
        }
        return this._modName.equals(that._modName);
    }

    public int hashCode() {
        int result = this._modName.hashCode();
        result = 31 * result + (this._exported ? 1 : 0);
        return result;
    }
}

