/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.init;

import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.lang.GosuShop;
import gw.lang.UnstableAPI;
import gw.lang.init.GosuPathEntry;
import gw.lang.init.ModuleFileUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@UnstableAPI
public class ClasspathToGosuPathEntryUtil {
    static final String GW_FORBID_GOSU_JARS = "gw.forbid.gosu.jars";

    public static List<GosuPathEntry> convertClasspathToGosuPathEntries(List<IDirectory> classpath) {
        boolean loadingGosuFromJarsForbidden = Boolean.getBoolean(GW_FORBID_GOSU_JARS);
        ClassPathToGosuPathConverterBlock pathConverterBlock = new ClassPathToGosuPathConverterBlock();
        for (IDirectory dir : classpath) {
            if (dir.getName().endsWith(".jar") && loadingGosuFromJarsForbidden) continue;
            ClasspathToGosuPathEntryUtil.executeOnSourceDirectory(dir, pathConverterBlock);
        }
        return pathConverterBlock.getPathEntries();
    }

    public static IDirectory findModuleRootFromSourceEntry(IDirectory dir) {
        ModuleFindFromSourceEntryBlock block = new ModuleFindFromSourceEntryBlock();
        ClasspathToGosuPathEntryUtil.executeOnSourceDirectory(dir, block);
        return block.getModuleDir();
    }

    private static IDirectory executeOnSourceDirectory(IDirectory dir, SourceDirectoryBlock block) {
        IFile moduleFile = dir.file("pom.xml");
        IDirectory foundModule = null;
        if (moduleFile != null && moduleFile.exists()) {
            block.doIt(dir, moduleFile);
        } else if (!dir.getName().endsWith(".jar")) {
            IDirectory parentDir = dir.getParent();
            if (parentDir != null) {
                IFile parentModuleFile = parentDir.file("pom.xml");
                if (parentModuleFile.exists() && ClasspathToGosuPathEntryUtil.moduleContainsSourceDir(parentModuleFile, dir)) {
                    block.doIt(parentDir, parentModuleFile);
                } else {
                    block.doIt(dir, null);
                }
            } else {
                block.doIt(dir, null);
            }
        } else {
            block.doIt(dir, null);
        }
        return foundModule;
    }

    private static boolean moduleContainsSourceDir(IFile moduleFile, IDirectory dir) {
        for (IDirectory iDirectory : ModuleFileUtil.createPathEntryForModuleFile(moduleFile).getSources()) {
            if (!iDirectory.equals(dir)) continue;
            return true;
        }
        return false;
    }

    private static class ClassPathToGosuPathConverterBlock
    implements SourceDirectoryBlock {
        private final List<GosuPathEntry> _pathEntries = new ArrayList<GosuPathEntry>();

        @Override
        public void doIt(IDirectory dir, IFile moduleFile) {
            if (!this.moduleAlreadyIncluded(dir, this._pathEntries)) {
                if (moduleFile == null) {
                    this._pathEntries.add(new GosuPathEntry(dir, Collections.singletonList(dir)));
                } else {
                    this._pathEntries.add(GosuShop.createPathEntryFromModuleFile(moduleFile));
                }
            }
        }

        public List<? extends GosuPathEntry> getPathEntries() {
            return this._pathEntries;
        }

        private boolean moduleAlreadyIncluded(IDirectory rootDir, List<GosuPathEntry> pathEntries) {
            for (GosuPathEntry entry : pathEntries) {
                if (!rootDir.equals(entry.getRoot()) && !rootDir.isDescendantOf(entry.getRoot())) continue;
                return true;
            }
            return false;
        }
    }

    private static class ModuleFindFromSourceEntryBlock
    implements SourceDirectoryBlock {
        public IDirectory _moduleDir;

        private ModuleFindFromSourceEntryBlock() {
        }

        @Override
        public void doIt(IDirectory dir, IFile moduleFile) {
            this._moduleDir = dir;
        }

        public IDirectory getModuleDir() {
            return this._moduleDir;
        }
    }

    private static interface SourceDirectoryBlock {
        public void doIt(IDirectory var1, IFile var2);
    }
}

