/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.init;

import gw.config.CommonServices;
import gw.lang.UnstableAPI;
import gw.lang.gosuc.GosucModule;
import gw.lang.init.GosuPathEntry;
import gw.lang.init.GosuRuntimeManifoldHost;
import gw.lang.init.IGosuInitialization;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IModule;
import gw.util.GosuExceptionUtil;
import gw.util.concurrent.LocklessLazyVar;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

@UnstableAPI
public class GosuInitialization {
    private static final String GW_ENABLE_ALTERNATE_LOCKING_STRATEGY = "gw.enable.alternate.locking.strategy";
    public static final boolean _enableAlternateLockingStrategy = Boolean.getBoolean("gw.enable.alternate.locking.strategy");
    private static final Map<IExecutionEnvironment, GosuInitialization> INSTANCES = new WeakHashMap<IExecutionEnvironment, GosuInitialization>();
    private IExecutionEnvironment _execEnv;
    private boolean _initialized;
    private static final LocklessLazyVar<Void> _initMessage = new LocklessLazyVar<Void>(){

        @Override
        protected Void init() {
            CommonServices.getEntityAccess().getLogger().info("Alternative classloader locking strategy: " + (_enableAlternateLockingStrategy ? "Enabled" : "Disabled"));
            return null;
        }
    };

    public static GosuInitialization instance(IExecutionEnvironment execEnv) {
        GosuInitialization gi = INSTANCES.get(execEnv);
        if (gi == null) {
            gi = new GosuInitialization(execEnv);
            INSTANCES.put(execEnv, gi);
        }
        return gi;
    }

    public static boolean isAnythingInitialized() {
        return !INSTANCES.isEmpty();
    }

    private GosuInitialization(IExecutionEnvironment execEnv) {
        this._execEnv = execEnv;
        this._initialized = false;
        _initMessage.get();
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void uninitializeRuntime() {
        if (!this._initialized) {
            return;
        }
        this._initialized = false;
        this.getGosuInitialization().uninitializeRuntime(this._execEnv);
    }

    public void uninitializeSimpleIde() {
        if (!this._initialized) {
            return;
        }
        this._initialized = false;
        this.getGosuInitialization().uninitializeSimpleIde(this._execEnv);
    }

    public void initializeRuntime(List<GosuPathEntry> pathEntries, String ... discretePackages) {
        if (this._initialized) {
            throw new IllegalStateException("Illegal attempt to re-initialize Gosu");
        }
        this.getGosuInitialization().initializeRuntime(this._execEnv, pathEntries, discretePackages);
        this._initialized = true;
    }

    public void initializeCompiler(GosucModule module) {
        if (this._initialized) {
            throw new IllegalStateException("Illegal attempt to re-initialize Gosu");
        }
        this.getGosuInitialization().initializeCompiler(this._execEnv, module);
        this._initialized = true;
        GosuRuntimeManifoldHost.clear();
        GosuRuntimeManifoldHost.get().init(module.getAllSourceRoots().stream().map(this.makeFile()).collect(Collectors.toList()), module.getClasspath().stream().filter(p -> !p.startsWith("jrt:")).map(this.makeFile()).collect(Collectors.toList()));
    }

    private Function<String, File> makeFile() {
        return name -> name.startsWith("file:") ? new File(URI.create(name)) : new File((String)name);
    }

    public void uninitializeCompiler() {
        if (!this._initialized) {
            throw new IllegalStateException("Illegal attempt to uninitialize Gosu");
        }
        this.getGosuInitialization().uninitializeCompiler(this._execEnv);
        this._initialized = false;
    }

    public void reinitializeRuntime(List<GosuPathEntry> pathEntries, String ... discretePackages) {
        if (this._initialized) {
            this.uninitializeRuntime();
            this.getGosuInitialization().reinitializeRuntime(this._execEnv, pathEntries, discretePackages);
        } else {
            this.getGosuInitialization().initializeRuntime(this._execEnv, pathEntries, discretePackages);
        }
        this._initialized = true;
    }

    public void reinitializeSimpleIde(GosucModule module) {
        if (this._initialized) {
            this.uninitializeSimpleIde();
            this.getGosuInitialization().reinitializeSimpleIde(this._execEnv, module);
        } else {
            this.getGosuInitialization().initializeSimpleIde(this._execEnv, module);
        }
        this._initialized = true;
    }

    public void initializeMultipleModules(List<? extends IModule> modules) {
        if (this._initialized) {
            throw new IllegalStateException("Illegal attempt to initialize Gosu");
        }
        this.getGosuInitialization().initializeMultipleModules(this._execEnv, modules);
        this._initialized = true;
    }

    public void uninitializeMultipleModules() {
        if (!this._initialized) {
            throw new IllegalStateException("Illegal attempt to uninitialize Gosu");
        }
        this.getGosuInitialization().uninitializeMultipleModules(this._execEnv);
        this._initialized = true;
    }

    private IGosuInitialization getGosuInitialization() {
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.init.InternalGosuInit");
            Method m = cls.getMethod("instance", new Class[0]);
            return (IGosuInitialization)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow(e);
        }
    }
}

