/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir;

import gw.internal.ext.org.objectweb.asm.signature.SignatureVisitor;
import gw.internal.ext.org.objectweb.asm.signature.SignatureWriter;
import gw.lang.UnstableAPI;
import gw.lang.ir.IRAnnotation;
import gw.lang.ir.IRType;
import gw.lang.ir.SignatureUtil;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.reflect.ICompoundType;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class IRClass {
    private int _modifiers;
    private String _name;
    private IRType _thisType;
    private IRType _superType;
    private List<IRType> _interfaces = new ArrayList<IRType>();
    private List<InnerClassInfo> _innerClasses = new ArrayList<InnerClassInfo>();
    private String _sourceFile;
    private List<IRMethodStatement> _methods = new ArrayList<IRMethodStatement>();
    private List<IRFieldDecl> _fields = new ArrayList<IRFieldDecl>();
    private List<IRAnnotation> _annotations = new ArrayList<IRAnnotation>();
    private String _genericSignature;

    public int getModifiers() {
        return this._modifiers;
    }

    public void setModifiers(int modifiers) {
        this._modifiers = modifiers;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public IRType getThisType() {
        return this._thisType;
    }

    public void setThisType(IRType thisType) {
        this._thisType = thisType;
    }

    public IRType getSuperType() {
        return this._superType;
    }

    public void setSuperType(IRType superType) {
        this._superType = superType;
    }

    public void addInterface(IRType iface) {
        this._interfaces.add(iface);
    }

    public List<IRType> getInterfaces() {
        return this._interfaces;
    }

    public String getSourceFile() {
        return this._sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this._sourceFile = sourceFile;
    }

    public void addInnerClass(IRType innerClass, IRType enclosingType, int modifiers) {
        this._innerClasses.add(new InnerClassInfo(innerClass, enclosingType, modifiers));
    }

    public void addMethod(IRMethodStatement method) {
        this._methods.add(method);
    }

    public void addField(IRFieldDecl field) {
        this._fields.add(field);
    }

    public List<InnerClassInfo> getInnerClasses() {
        return this._innerClasses;
    }

    public List<IRMethodStatement> getMethods() {
        return this._methods;
    }

    public List<IRFieldDecl> getFields() {
        return this._fields;
    }

    public List<IRAnnotation> getAnnotations() {
        return this._annotations;
    }

    public void setAnnotations(List<IRAnnotation> annotations) {
        this._annotations = annotations;
    }

    public void makeGenericSignature(IType type) {
        SignatureVisitor sv;
        boolean[] bGeneric = new boolean[]{false};
        SignatureWriter sw = new SignatureWriter();
        if (type.isGenericType()) {
            bGeneric[0] = true;
            for (IGenericTypeVariable tv : type.getGenericTypeVariables()) {
                sw.visitFormalTypeParameter(tv.getName());
                IType boundingType = tv.getBoundingType();
                if (boundingType != null) {
                    IType[] types = boundingType instanceof ICompoundType ? ((ICompoundType)boundingType).getTypes().toArray(new IType[0]) : new IType[]{boundingType};
                    for (int i = types.length - 1; i >= 0; --i) {
                        SignatureVisitor sv2 = types[i].isInterface() ? sw.visitInterfaceBound() : sw.visitClassBound();
                        SignatureUtil.visitType(sv2, SignatureUtil.getPureGenericType(types[i]), bGeneric);
                    }
                    continue;
                }
                SignatureVisitor sv3 = sw.visitClassBound();
                SignatureUtil.visitType(sv3, JavaTypes.OBJECT(), bGeneric);
            }
        }
        if (type.getSupertype() != null) {
            sv = sw.visitSuperclass();
            SignatureUtil.visitType(sv, type.getSupertype(), bGeneric);
        } else {
            sv = sw.visitSuperclass();
            SignatureUtil.visitType(sv, JavaTypes.OBJECT(), bGeneric);
        }
        if (type.getInterfaces() != null) {
            for (IType iface : type.getInterfaces()) {
                SignatureVisitor sv4 = sw.visitInterface();
                SignatureUtil.visitType(sv4, iface, bGeneric);
            }
        }
        if (bGeneric[0]) {
            this._genericSignature = sw.toString();
        }
    }

    public String getGenericSignature() {
        return this._genericSignature;
    }

    public static class InnerClassInfo {
        private IRType _innerClass;
        private IRType _enclosingType;
        private int _modifiers;

        public InnerClassInfo(IRType innerClass, IRType enclosingType, int modifiers) {
            this._innerClass = innerClass;
            this._enclosingType = enclosingType;
            this._modifiers = modifiers;
        }

        public IRType getInnerClass() {
            return this._innerClass;
        }

        public IRType getEnclosingType() {
            return this._enclosingType;
        }

        public int getModifiers() {
            return this._modifiers;
        }
    }
}

