/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir;

import gw.lang.GosuShop;
import gw.lang.UnstableAPI;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public abstract class IRElement {
    private IRElement _parent;
    private int _iLineNumber = -1;
    private boolean _bImplicit;

    protected IRElement() {
    }

    public IRElement getParent() {
        return this._parent;
    }

    public void setParent(IRElement parent) {
        this._parent = parent;
    }

    protected void setParentToThis(IRElement element) {
        if (element != null) {
            element.setParent(this);
        }
    }

    public boolean isImplicit() {
        return this._bImplicit || this.getParent() != null && this.getParent().isImplicit();
    }

    public void setImplicit(boolean bImplicit) {
        this._bImplicit = bImplicit;
    }

    public int getLineNumber() {
        if (!this.isImplicit()) {
            return this._iLineNumber;
        }
        return -1;
    }

    public void setLineNumber(int iLineNumber) {
        if (!this.isImplicit()) {
            this._iLineNumber = iLineNumber;
        }
    }

    public static IRType maybeEraseStructuralType(IRType type) {
        return IRElement.maybeEraseStructuralType(null, type);
    }

    public static IRType maybeEraseStructuralType(IRType ownersType, IRType type) {
        IRType originalType = type;
        int iArrayDims = 0;
        while (type.isArray()) {
            ++iArrayDims;
            type = type.getComponentType();
        }
        if (ownersType == null ? type.isStructural() : type.isStructuralAndErased(ownersType)) {
            type = GosuShop.getIRTypeResolver().getDescriptor(Object.class);
            while (iArrayDims-- > 0) {
                type = type.getArrayType();
            }
        } else {
            type = originalType;
        }
        return type;
    }

    protected List<IRType> maybeEraseStructuralTypes(IRType ownersType, List<IRType> types) {
        ArrayList<IRType> altTypes = null;
        for (int i = 0; i < types.size(); ++i) {
            IRType csr = types.get(i);
            IRType type = IRElement.maybeEraseStructuralType(ownersType, csr);
            if (type == csr) continue;
            if (altTypes == null) {
                altTypes = new ArrayList<IRType>(types);
            }
            altTypes.set(i, type);
        }
        return altTypes == null ? types : altTypes;
    }

    protected List<IRSymbol> maybeEraseStructuralSymbolTypes(List<IRSymbol> parameters) {
        for (IRSymbol csr : parameters) {
            IRType type = IRElement.maybeEraseStructuralType(null, csr.getType());
            if (type == csr.getType()) continue;
            csr.setType(type);
        }
        return parameters;
    }
}

