/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir;

import gw.internal.ext.org.objectweb.asm.signature.SignatureVisitor;
import gw.lang.ir.IRType;
import gw.lang.reflect.ICompoundType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;

public class SignatureUtil {
    public static void visitIrType(SignatureVisitor sv, IRType type) {
        if (type.isArray()) {
            SignatureVisitor arrSv = sv.visitArrayType();
            SignatureUtil.visitIrType(arrSv, type.getComponentType());
        } else if (type.isPrimitive()) {
            sv.visitBaseType(type.getDescriptor().charAt(0));
        } else {
            sv.visitClassType(type.getSlashName());
            sv.visitEnd();
        }
    }

    public static void visitType(SignatureVisitor sv, IType type, boolean[] bGeneric) {
        if (type instanceof ITypeVariableType) {
            sv.visitTypeVariable(type.getRelativeName());
        } else if (!TypeSystem.isBytecodeType(type)) {
            if (type instanceof IFunctionType) {
                type = TypeSystem.getFunctionalInterface((IFunctionType)type);
                SignatureUtil.visitType(sv, type, bGeneric);
            } else {
                sv.visitClassType(Object.class.getName().replace('.', '/'));
                sv.visitEnd();
            }
        } else if (type.isArray()) {
            SignatureVisitor arrSv = sv.visitArrayType();
            SignatureUtil.visitType(arrSv, type.getComponentType(), bGeneric);
        } else if (type.isPrimitive()) {
            String name = type.getName();
            int c = name.equals("boolean") ? 90 : (name.equals("long") ? 74 : (int)Character.toUpperCase(name.charAt(0)));
            sv.visitBaseType((char)c);
        } else {
            IType rawType = SignatureUtil.makeRawType(type);
            String rawName = rawType.isPrimitive() ? rawType.getName() : SignatureUtil.processName(rawType);
            sv.visitClassType(rawName);
            if (type.isParameterizedType()) {
                bGeneric[0] = true;
                for (IType param : type.getTypeParameters()) {
                    sv.visitTypeArgument('=');
                    SignatureUtil.visitType(sv, param, bGeneric);
                }
            }
            if (!rawType.isPrimitive()) {
                sv.visitEnd();
            }
        }
    }

    private static IType makeRawType(IType type) {
        IType ret = type instanceof ICompoundType ? SignatureUtil.makeRawType(((ICompoundType)type).getTypes().iterator().next()) : (type.getGenericType() == null ? type : type.getGenericType());
        return ret;
    }

    public static IType getPureGenericType(IType type) {
        while (type.isParameterizedType()) {
            type = type.getGenericType();
        }
        return type;
    }

    private static String processName(IType type) {
        String name = SignatureUtil.makeJavaName(type);
        if (name.length() > "_proxy_".length() && name.startsWith("_proxy_")) {
            name = IGosuClass.ProxyUtil.getNameSansProxy(name);
        }
        return name.replace('.', '/');
    }

    private static String makeJavaName(IType type) {
        IType enclosingType = type.getEnclosingType();
        if (enclosingType != null) {
            return SignatureUtil.makeJavaName(enclosingType) + "$" + SignatureUtil.getSimpleName(type.getRelativeName());
        }
        return type.getName();
    }

    public static String getSimpleName(String name) {
        int iDot = name.lastIndexOf(46);
        if (iDot >= 0) {
            return name.substring(iDot + 1);
        }
        return name;
    }
}

