/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.builder.statement;

import gw.lang.UnstableAPI;
import gw.lang.ir.IJavaClassIRType;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRType;
import gw.lang.ir.builder.IRArgConverter;
import gw.lang.ir.builder.IRBuilderContext;
import gw.lang.ir.builder.IRExpressionBuilder;
import gw.lang.ir.builder.IRStatementBuilder;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRFieldSetStatement;
import gw.lang.reflect.java.IJavaClassField;

@UnstableAPI
public class IRFieldSetStatementBuilder
extends IRStatementBuilder {
    private BuilderImpl _builder;

    public IRFieldSetStatementBuilder(IRExpressionBuilder root, String name, IRExpressionBuilder value) {
        this._builder = new RootAndNameBuilder(root, name, value);
    }

    @Override
    protected IRStatement buildImpl(IRBuilderContext context) {
        return this._builder.buildImpl(context);
    }

    private static final class RootAndNameBuilder
    implements BuilderImpl {
        private IRExpressionBuilder _root;
        private String _name;
        private IRExpressionBuilder _value;

        private RootAndNameBuilder(IRExpressionBuilder root, String name, IRExpressionBuilder value) {
            this._root = root;
            this._name = name;
            this._value = value;
        }

        @Override
        public IRFieldSetStatement buildImpl(IRBuilderContext context) {
            IRExpression root = this._root.build(context);
            IRType rootType = root.getType();
            if (rootType instanceof IJavaClassIRType) {
                IJavaClassField field = IRFieldSetStatementBuilder.findField(((IJavaClassIRType)rootType).getJavaClassInfo(), this._name);
                IRExpression value = IRArgConverter.castOrConvertIfNecessary(IRFieldSetStatementBuilder.getIRType(field.getType()), this._value.build(context));
                return new IRFieldSetStatement(root, value, this._name, IRFieldSetStatementBuilder.getIRType(field.getType()), IRFieldSetStatementBuilder.getIRType(field.getEnclosingClass()));
            }
            if (rootType.equals(context.owningType())) {
                IRFieldDecl field = context.findField(this._name);
                IRExpression value = IRArgConverter.castOrConvertIfNecessary(field.getType(), this._value.build(context));
                return new IRFieldSetStatement(root, value, this._name, field.getType(), context.owningType());
            }
            throw new IllegalArgumentException("Cannot reference a field only by name on a root expression that's not an IJavaClassIRType");
        }
    }

    private static interface BuilderImpl {
        public IRFieldSetStatement buildImpl(IRBuilderContext var1);
    }
}

