/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.expression;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;

@UnstableAPI
public class IRRelationalExpression
extends IRExpression {
    private IRExpression _lhs;
    private IRExpression _rhs;
    private Operation _op;

    public IRRelationalExpression(IRExpression lhs, IRExpression rhs, Operation op) {
        this._lhs = lhs;
        this._rhs = rhs;
        this._op = op;
        lhs.setParent(this);
        rhs.setParent(this);
    }

    public IRExpression getLhs() {
        return this._lhs;
    }

    public IRExpression getRhs() {
        return this._rhs;
    }

    public Operation getOp() {
        return this._op;
    }

    @Override
    public IRType getType() {
        return IRTypeConstants.pBOOLEAN();
    }

    public static enum Operation {
        GT,
        GTE,
        LT,
        LTE;


        public static Operation get(String strOp) {
            if (strOp.equals(">")) {
                return GT;
            }
            if (strOp.equals(">=")) {
                return GTE;
            }
            if (strOp.equals("<")) {
                return LT;
            }
            if (strOp.equals("<=")) {
                return LTE;
            }
            throw new IllegalArgumentException("Unrecognized relational operation " + strOp);
        }
    }
}

