/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.template;

import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.resources.Res;
import gw.lang.parser.resources.ResourceKey;

public class TemplateParseException
extends Exception {
    private ParseResultsException _pe;
    private ResourceKey _reasonKey;
    private String[] _args;
    private String _strTemplateSource;
    private int _lineNumber;
    private int _column;
    private int _offset;

    public TemplateParseException(ResourceKey reason, int lineNumber, int column, int offset, String ... args) {
        this(Res.get(reason, args), null, null, lineNumber, column, offset, reason, args);
    }

    public TemplateParseException(ParseResultsException pe, String strTemplateSource) {
        this(TemplateParseException.makeTemplateParseExceptionMessage(pe, strTemplateSource), pe, strTemplateSource, 0, 0, 0, null, null);
    }

    public TemplateParseException(String strReason, ParseResultsException pe, String strTemplateSource, int lineNumber, int column, int offset, ResourceKey reason, String[] args) {
        super(strReason);
        this._reasonKey = reason;
        this._args = args;
        this._pe = pe;
        this._strTemplateSource = strTemplateSource;
        this._lineNumber = lineNumber;
        this._column = column;
        this._offset = offset;
    }

    public ParseResultsException getParseException() {
        return this._pe;
    }

    public String getTemplateSource() {
        return this._strTemplateSource;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    @Override
    public String getMessage() {
        if (this._pe != null) {
            return TemplateParseException.makeTemplateParseExceptionMessage(this._pe, this._strTemplateSource);
        }
        return Res.get(this._reasonKey, this._args);
    }

    private static String makeTemplateParseExceptionMessage(ParseResultsException e, String strCompiledSource) {
        Object strFeedback = e.getFeedback();
        strFeedback = (String)strFeedback + "\n" + Res.get(Res.MSG_TEMPLATE_EXCEPTION_GENERATED_SOURCE, new Object[0]) + ":\n" + strCompiledSource;
        return strFeedback;
    }

    public int getColumn() {
        return this._column;
    }

    public int getOffset() {
        return this._offset;
    }
}

