/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.config.CommonServices;
import gw.lang.parser.CICS;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IGenericMethodInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.PropertyInfoDelegate;
import gw.lang.reflect.PropertyNameMap;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.DynamicArray;
import gw.util.GosuExceptionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureManager<T extends CharSequence> {
    private final boolean _caseSensitive;
    private final boolean _addObjectMethods;
    private IRelativeTypeInfo _typeInfo;
    private volatile Map<IModule, InitState> _methodsInitialized = new HashMap<IModule, InitState>();
    private volatile Map<IModule, InitState> _propertiesInitialized = new HashMap<IModule, InitState>();
    private volatile InitState _ctorsInitialized = InitState.NotInitialized;
    private Map<IModule, PropertyNameMap<T>[]> _properties = new HashMap<IModule, PropertyNameMap<T>[]>();
    private Map<IModule, MethodList[]> _methods = new HashMap<IModule, MethodList[]>();
    private List<IConstructorInfo>[] _constructors = new List[IRelativeTypeInfo.Accessibility_Size];
    private String _superPropertyPrefix;
    private IType _supertypeToCopyPropertiesFrom;

    public FeatureManager(IRelativeTypeInfo typeInfo, boolean caseSensitive) {
        this(typeInfo, caseSensitive, false);
    }

    public FeatureManager(IRelativeTypeInfo typeInfo, boolean caseSensitive, boolean addObjectMethods) {
        this._typeInfo = typeInfo;
        this._caseSensitive = caseSensitive;
        this._addObjectMethods = addObjectMethods;
    }

    public static IRelativeTypeInfo.Accessibility getAccessibilityForClass(IType ownersClass, IType whosAskin) {
        if (TypeSystem.isIncludeAll()) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        if (ownersClass == null || whosAskin == null) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        if (FeatureManager.getTopLevelTypeName(whosAskin).equals(FeatureManager.getTopLevelTypeName(ownersClass))) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        if (Modifier.isPrivate(ownersClass.getModifiers())) {
            return IRelativeTypeInfo.Accessibility.NONE;
        }
        if (FeatureManager.isInSameNamespace(ownersClass, whosAskin)) {
            return IRelativeTypeInfo.Accessibility.INTERNAL;
        }
        if (Modifier.isInternal(ownersClass.getModifiers())) {
            return IRelativeTypeInfo.Accessibility.NONE;
        }
        if (FeatureManager.isInEnclosingClassHierarchy(ownersClass, whosAskin)) {
            return IRelativeTypeInfo.Accessibility.PROTECTED;
        }
        return IRelativeTypeInfo.Accessibility.PUBLIC;
    }

    public static boolean isInSameNamespace(IType ownersClass, IType whosAskin) {
        ownersClass = IGosuClass.ProxyUtil.getProxiedType(ownersClass);
        String whosAskinNamespace = FeatureManager.getTopLevelEnclosingClassNamespace(whosAskin = IGosuClass.ProxyUtil.getProxiedType(whosAskin));
        return whosAskinNamespace != null && whosAskinNamespace.equals(FeatureManager.getTopLevelEnclosingClassNamespace(ownersClass));
    }

    private static String getTopLevelEnclosingClassNamespace(IType type) {
        IType topLevelClass = type;
        while (topLevelClass.getEnclosingType() != null) {
            topLevelClass = topLevelClass.getEnclosingType();
        }
        return topLevelClass.getNamespace();
    }

    public static boolean isInEnclosingClassHierarchy(IType ownersClass, IType whosAskin) {
        return whosAskin != null && ownersClass != null && (FeatureManager.isInHierarchy(ownersClass, whosAskin) || FeatureManager.isInEnhancedTypesHierarchy(ownersClass, whosAskin) || FeatureManager.isInEnclosingClassHierarchy(ownersClass, whosAskin.getEnclosingType()));
    }

    protected static boolean isInEnhancedTypesHierarchy(IType ownersClass, IType whosAskin) {
        return whosAskin instanceof IGosuEnhancement && ((IGosuEnhancement)whosAskin).getEnhancedType() != null && ownersClass.isAssignableFrom(((IGosuEnhancement)whosAskin).getEnhancedType());
    }

    protected static boolean isInHierarchy(IType ownersClass, IType whosAskin) {
        return ownersClass.isAssignableFrom(whosAskin) || ownersClass.getEnclosingType() != null && FeatureManager.isInHierarchy(ownersClass.getEnclosingType(), whosAskin) || ownersClass instanceof IGosuClass && ((IGosuClass)ownersClass).isSubClass(whosAskin);
    }

    private static String getTopLevelTypeName(IType type) {
        while (type.getEnclosingType() != null) {
            type = TypeSystem.getPureGenericType(type.getEnclosingType());
        }
        return TypeSystem.getPureGenericType(type).getName();
    }

    public static boolean isFeatureAccessible(IAttributedFeatureInfo property, IRelativeTypeInfo.Accessibility accessibility) {
        boolean isAccessible = false;
        switch (accessibility) {
            case NONE: {
                break;
            }
            case PUBLIC: {
                if (!property.isPublic()) break;
                isAccessible = true;
                break;
            }
            case PROTECTED: {
                if (!property.isPublic() && !property.isProtected()) break;
                isAccessible = true;
                break;
            }
            case INTERNAL: {
                if (!property.isPublic() && !property.isInternal() && !property.isProtected()) break;
                isAccessible = true;
                break;
            }
            case PRIVATE: {
                if (!property.isPublic() && !property.isInternal() && !property.isProtected() && !property.isPrivate()) break;
                isAccessible = true;
            }
        }
        return isAccessible;
    }

    public void clear() {
        this._methodsInitialized = new HashMap<IModule, InitState>();
        this._propertiesInitialized = new HashMap<IModule, InitState>();
        this._ctorsInitialized = InitState.NotInitialized;
        this.clearMaps();
    }

    private void clearMaps() {
        int i;
        for (PropertyNameMap<T>[] properties : this._properties.values()) {
            for (i = 0; i < properties.length; ++i) {
                properties[i] = null;
            }
        }
        for (int i2 = 0; i2 < this._constructors.length; ++i2) {
            this._constructors[i2] = null;
        }
        for (MethodList[] methods : this._methods.values()) {
            for (i = 0; i < methods.length; ++i) {
                methods[i] = null;
            }
        }
    }

    private void clearProperties(IModule module) {
        PropertyNameMap<T>[] properties = this._properties.get(module);
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                properties[i] = null;
            }
        }
    }

    private void clearMethods(IModule module) {
        MethodList[] methods = this._methods.get(module);
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                methods[i] = null;
            }
        }
    }

    private void clearCtors() {
        for (int i = 0; i < this._constructors.length; ++i) {
            this._constructors[i] = null;
        }
    }

    public List<IPropertyInfo> getProperties(IRelativeTypeInfo.Accessibility accessibility) {
        this.maybeInitProperties();
        PropertyNameMap<T>[] arr = this._properties.get(TypeSystem.getCurrentModule());
        if (arr == null) {
            return Collections.emptyList();
        }
        PropertyNameMap<T> props = arr[accessibility.ordinal()];
        return props == null ? Collections.emptyList() : props.values();
    }

    public IPropertyInfo getProperty(IRelativeTypeInfo.Accessibility accessibility, CharSequence propName) {
        this.maybeInitProperties();
        PropertyNameMap<T>[] arr = this._properties.get(TypeSystem.getCurrentModule());
        if (arr == null) {
            return null;
        }
        PropertyNameMap<T> accessMap = arr[accessibility.ordinal()];
        return accessMap == null ? null : accessMap.get(this.convertCharSequenceToCorrectSensitivity(propName));
    }

    private T convertCharSequenceToCorrectSensitivity(CharSequence propName) {
        return (T)(this._caseSensitive ? (propName == null ? "" : propName.toString()) : CICS.get(propName));
    }

    public MethodList getMethods(IRelativeTypeInfo.Accessibility accessibility) {
        this.maybeInitMethods();
        MethodList[] arr = this._methods.get(TypeSystem.getCurrentModule());
        if (arr == null) {
            return MethodList.EMPTY;
        }
        MethodList iMethodInfos = arr[accessibility.ordinal()];
        return iMethodInfos == null ? MethodList.EMPTY : iMethodInfos;
    }

    public IMethodInfo getMethod(IRelativeTypeInfo.Accessibility accessibility, CharSequence methodName, IType ... params) {
        this.maybeInitMethods();
        return ITypeInfo.FIND.method(this.getMethods(accessibility), methodName, params);
    }

    public List<? extends IConstructorInfo> getConstructors(IRelativeTypeInfo.Accessibility accessibility) {
        this.maybeInitConstructors();
        List<IConstructorInfo> list = this._constructors[accessibility.ordinal()];
        return list == null ? Collections.emptyList() : list;
    }

    public IConstructorInfo getConstructor(IRelativeTypeInfo.Accessibility accessibility, IType[] params) {
        this.maybeInitConstructors();
        return ITypeInfo.FIND.constructor(this.getConstructors(accessibility), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void maybeInitMethods() {
        block22: {
            IModule module = TypeSystem.getCurrentModule();
            if (module == null) {
                throw new NullPointerException("Cannot init the FeatureManager with no current module.");
            }
            if (this._methodsInitialized.get(module) != InitState.Initialized && this._methodsInitialized.get(module) != InitState.ERROR) {
                TypeSystem.lock();
                try {
                    if (this._methodsInitialized.get(module) == InitState.Initialized) break block22;
                    if (this._methodsInitialized.get(module) == InitState.Initializing) {
                        throw new IllegalStateException("Methods for " + this._typeInfo.getOwnersType() + " are cyclic.");
                    }
                    this._methodsInitialized.put(module, InitState.Initializing);
                    this.clearMethods(module);
                    try {
                        void var6_9;
                        MethodList[] methods = new MethodList[IRelativeTypeInfo.Accessibility_Size];
                        MethodList privateMethods = new MethodList();
                        if (this._addObjectMethods) {
                            this.mergeMethods(privateMethods, this.convertType(JavaTypes.OBJECT()), false);
                        }
                        if (this._typeInfo == null) {
                            throw new IllegalStateException("Null TypeInfo");
                        }
                        if (this._typeInfo.getOwnersType() == null) {
                            throw new IllegalStateException("null owner");
                        }
                        if (this._typeInfo.getOwnersType().getInterfaces() == null) {
                            throw new IllegalStateException("null interfaces for " + this._typeInfo.getOwnersType().getName());
                        }
                        IType[] iTypeArray = this._typeInfo.getOwnersType().getInterfaces();
                        int n = iTypeArray.length;
                        boolean bl = false;
                        while (var6_9 < n) {
                            IType type = iTypeArray[var6_9];
                            this.mergeMethods(privateMethods, this.convertType(type), false);
                            ++var6_9;
                        }
                        if (this.getSuperType() != null) {
                            this.mergeMethods(privateMethods, this.convertType(this.getSuperType()), true);
                        }
                        List<? extends IMethodInfo> declaredMethods = this._typeInfo.getDeclaredMethods();
                        for (IMethodInfo iMethodInfo : declaredMethods) {
                            this.mergeMethod(privateMethods, iMethodInfo, true);
                        }
                        this.addEnhancementMethods(privateMethods);
                        privateMethods.trimToSize();
                        methods[IRelativeTypeInfo.Accessibility.PRIVATE.ordinal()] = privateMethods;
                        methods[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()] = privateMethods.filterMethods(IRelativeTypeInfo.Accessibility.PROTECTED);
                        if (methods[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()].size() == privateMethods.size()) {
                            methods[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()] = privateMethods;
                        }
                        methods[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()] = privateMethods.filterMethods(IRelativeTypeInfo.Accessibility.INTERNAL);
                        if (methods[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()].size() == methods[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()].size()) {
                            methods[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()] = methods[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()];
                        }
                        methods[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()] = privateMethods.filterMethods(IRelativeTypeInfo.Accessibility.PUBLIC);
                        if (methods[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()].size() == methods[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()].size()) {
                            methods[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()] = methods[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()];
                        }
                        methods[IRelativeTypeInfo.Accessibility.NONE.ordinal()] = MethodList.EMPTY;
                        this._methods.put(module, methods);
                        this._methodsInitialized.put(module, InitState.Initialized);
                    }
                    finally {
                        if (this._methodsInitialized.get(module) != InitState.Initialized) {
                            this._methodsInitialized.put(module, InitState.ERROR);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw GosuExceptionUtil.forceThrow(ex, this._typeInfo.getOwnersType().getName());
                }
                finally {
                    TypeSystem.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeInitProperties() {
        block18: {
            this.maybeInitMethods();
            IModule module = TypeSystem.getCurrentModule();
            if (module == null) {
                throw new NullPointerException("Cannot init the FeatureManager with no current module.");
            }
            if (this._propertiesInitialized.get(module) != InitState.Initialized && this._propertiesInitialized.get(module) != InitState.ERROR) {
                TypeSystem.lock();
                try {
                    if (this._propertiesInitialized.get(module) == InitState.Initialized) break block18;
                    if (this._propertiesInitialized.get(module) == InitState.Initializing) {
                        throw new IllegalStateException("Properties for " + this._typeInfo.getOwnersType() + " are cyclic.");
                    }
                    this._propertiesInitialized.put(module, InitState.Initializing);
                    this.clearProperties(module);
                    try {
                        PropertyNameMap[] properties = new PropertyNameMap[IRelativeTypeInfo.Accessibility_Size];
                        PropertyNameMap privateProps = new PropertyNameMap();
                        for (IType iType : this._typeInfo.getOwnersType().getInterfaces()) {
                            this.mergeProperties(privateProps, this.convertType(iType), false);
                        }
                        IType supertype = this.getSuperType();
                        if (supertype != null) {
                            this.mergeProperties(privateProps, this.convertType(supertype), true);
                        }
                        List<? extends IPropertyInfo> declaredProperties = this._typeInfo.getDeclaredProperties();
                        for (IPropertyInfo iPropertyInfo : declaredProperties) {
                            this.mergeProperty(privateProps, iPropertyInfo, true);
                        }
                        this.addEnhancementProperties(privateProps, this._caseSensitive);
                        privateProps.freeze();
                        properties[IRelativeTypeInfo.Accessibility.PRIVATE.ordinal()] = privateProps;
                        properties[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()] = this.convertToMap(this.filterFeatures((List)privateProps.values(), IRelativeTypeInfo.Accessibility.PROTECTED));
                        if (properties[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()].size() == privateProps.size()) {
                            properties[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()] = privateProps;
                        }
                        properties[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()] = this.convertToMap(this.filterFeatures((List)privateProps.values(), IRelativeTypeInfo.Accessibility.INTERNAL));
                        if (properties[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()].size() == properties[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()].size()) {
                            properties[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()] = properties[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()];
                        }
                        properties[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()] = this.convertToMap(this.filterFeatures((List)privateProps.values(), IRelativeTypeInfo.Accessibility.PUBLIC));
                        if (properties[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()].size() == properties[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()].size()) {
                            properties[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()] = properties[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()];
                        }
                        properties[IRelativeTypeInfo.Accessibility.NONE.ordinal()] = new PropertyNameMap();
                        this._properties.put(module, properties);
                        this._propertiesInitialized.put(module, InitState.Initialized);
                    }
                    finally {
                        if (this._propertiesInitialized.get(module) != InitState.Initialized) {
                            this._propertiesInitialized.put(module, InitState.ERROR);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw GosuExceptionUtil.forceThrow(ex, this._typeInfo.getOwnersType().getName());
                }
                finally {
                    TypeSystem.unlock();
                }
            }
        }
    }

    private IType getSuperType() {
        IType ownersType = this._typeInfo.getOwnersType();
        IType supertype = ownersType.getSupertype();
        if (supertype == null && ownersType instanceof IJavaType && !this._typeInfo.getOwnersType().equals(JavaTypes.OBJECT())) {
            supertype = JavaTypes.OBJECT();
        }
        return supertype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeInitConstructors() {
        block19: {
            if (this._ctorsInitialized != InitState.Initialized && this._ctorsInitialized != InitState.ERROR) {
                TypeSystem.lock();
                try {
                    if (this._ctorsInitialized == InitState.Initialized) break block19;
                    if (this._ctorsInitialized == InitState.Initializing) {
                        throw new IllegalStateException("Constructors for " + this._typeInfo.getOwnersType() + " are cyclic.");
                    }
                    this._ctorsInitialized = InitState.Initializing;
                    this.clearCtors();
                    try {
                        if (this._ctorsInitialized != InitState.Initialized && this._ctorsInitialized != InitState.ERROR) {
                            this.clearCtors();
                            try {
                                List[] constructors = new List[IRelativeTypeInfo.Accessibility_Size];
                                List<? extends IConstructorInfo> privateConstructors = new ArrayList<IConstructorInfo>(this._typeInfo.getDeclaredConstructors());
                                ((ArrayList)privateConstructors).trimToSize();
                                privateConstructors = Collections.unmodifiableList(privateConstructors);
                                constructors[IRelativeTypeInfo.Accessibility.PRIVATE.ordinal()] = Collections.unmodifiableList(privateConstructors);
                                constructors[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()] = Collections.unmodifiableList(this.filterFeatures(privateConstructors, IRelativeTypeInfo.Accessibility.PROTECTED));
                                if (constructors[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()].size() == privateConstructors.size()) {
                                    constructors[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()] = privateConstructors;
                                }
                                constructors[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()] = Collections.unmodifiableList(this.filterFeatures(privateConstructors, IRelativeTypeInfo.Accessibility.INTERNAL));
                                if (constructors[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()].size() == constructors[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()].size()) {
                                    constructors[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()] = constructors[IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()];
                                }
                                constructors[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()] = Collections.unmodifiableList(this.filterFeatures(privateConstructors, IRelativeTypeInfo.Accessibility.PUBLIC));
                                if (constructors[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()].size() == constructors[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()].size()) {
                                    constructors[IRelativeTypeInfo.Accessibility.PUBLIC.ordinal()] = constructors[IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()];
                                }
                                constructors[IRelativeTypeInfo.Accessibility.NONE.ordinal()] = Collections.emptyList();
                                this._constructors = constructors;
                                this._ctorsInitialized = InitState.Initialized;
                            }
                            finally {
                                if (this._ctorsInitialized != InitState.Initialized) {
                                    this._ctorsInitialized = InitState.ERROR;
                                }
                            }
                        }
                        this._ctorsInitialized = InitState.Initialized;
                    }
                    finally {
                        if (this._ctorsInitialized != InitState.Initialized) {
                            this._ctorsInitialized = InitState.ERROR;
                        }
                    }
                }
                catch (Exception ex) {
                    throw GosuExceptionUtil.forceThrow(ex, this._typeInfo.getOwnersType().getName());
                }
                finally {
                    TypeSystem.unlock();
                }
            }
        }
    }

    protected IType convertType(IType type) {
        return type;
    }

    protected void addEnhancementMethods(List<IMethodInfo> privateMethods) {
        CommonServices.getEntityAccess().addEnhancementMethods(this._typeInfo.getOwnersType(), privateMethods);
    }

    protected void addEnhancementProperties(PropertyNameMap<T> privateProps, boolean caseSensitive) {
        CommonServices.getEntityAccess().addEnhancementProperties(this._typeInfo.getOwnersType(), privateProps, caseSensitive);
    }

    public void setSuperPropertyPrefix(String superPropertyPrefix) {
        this._superPropertyPrefix = superPropertyPrefix;
    }

    public void setSupertypeToCopyPropertiesFrom(IType supertypeToCopyPropertiesFrom) {
        this._supertypeToCopyPropertiesFrom = supertypeToCopyPropertiesFrom;
    }

    private PropertyNameMap<T> convertToMap(List<IPropertyInfo> features) {
        PropertyNameMap<T> ret = new PropertyNameMap<T>();
        for (IPropertyInfo feature : features) {
            ret.put(this.convertCharSequenceToCorrectSensitivity(feature.getName()), feature);
        }
        ret.freeze();
        return ret;
    }

    private List filterFeatures(List props, IRelativeTypeInfo.Accessibility accessibility) {
        ArrayList<IAttributedFeatureInfo> ret = new ArrayList<IAttributedFeatureInfo>();
        for (Object o : props) {
            IAttributedFeatureInfo property = (IAttributedFeatureInfo)o;
            if (!FeatureManager.isFeatureAccessible(property, accessibility)) continue;
            ret.add(property);
        }
        ret.trimToSize();
        return ret;
    }

    protected void mergeProperties(PropertyNameMap<T> props, IType type, boolean replace) {
        if (type != null) {
            List<? extends IPropertyInfo> propertyInfos = type.getTypeInfo() instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)type.getTypeInfo()).getProperties(this._typeInfo.getOwnersType()) : type.getTypeInfo().getProperties();
            for (IPropertyInfo iPropertyInfo : propertyInfos) {
                IType ownersType = iPropertyInfo.getOwnersType();
                if (this._supertypeToCopyPropertiesFrom != null && !ownersType.isAssignableFrom(this._supertypeToCopyPropertiesFrom) && !(ownersType instanceof IGosuEnhancement)) continue;
                this.mergeProperty(props, iPropertyInfo, replace);
            }
        }
    }

    protected void mergeProperty(PropertyNameMap<T> props, IPropertyInfo propertyInfo, boolean replace) {
        boolean prependPrefix = this._superPropertyPrefix != null && !propertyInfo.getOwnersType().equals(this._typeInfo.getOwnersType());
        T cs = this.convertCharSequenceToCorrectSensitivity((CharSequence)(prependPrefix ? this._superPropertyPrefix + propertyInfo.getName() : propertyInfo.getName()));
        if (replace || this.shouldReplace(props, cs, propertyInfo)) {
            if (prependPrefix) {
                props.put(cs, new PropertyInfoDelegate(propertyInfo.getContainer(), propertyInfo, cs.toString()));
            } else {
                props.put(cs, propertyInfo);
            }
        }
    }

    private boolean shouldReplace(PropertyNameMap<T> props, T cs, IPropertyInfo propertyInfo) {
        IPropertyInfo pi = props.get(cs);
        if (pi == null) {
            return true;
        }
        if (propertyInfo.isReadable() && propertyInfo.isWritable(this._typeInfo.getOwnersType())) {
            return !pi.isReadable() || !pi.isWritable();
        }
        return false;
    }

    protected void mergeMethods(MethodList methods, IType type, boolean replace) {
        if (type != null && !TypeSystem.isDeleted(type)) {
            MethodList methodInfos = type.getTypeInfo() instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)type.getTypeInfo()).getMethods(this._typeInfo.getOwnersType()) : type.getTypeInfo().getMethods();
            for (IMethodInfo methodInfo : methodInfos) {
                if (type.isInterface() && methodInfo.isStatic()) continue;
                this.mergeMethod(methods, methodInfo, replace);
            }
        }
    }

    protected void mergeMethod(MethodList methods, IMethodInfo thisMethodInfo, boolean replace) {
        IType[] paramTypes = null;
        DynamicArray<? extends IMethodInfo> matches = methods.getMethods(thisMethodInfo.getDisplayName());
        for (int i = 0; i < matches.size(); ++i) {
            IMethodInfo superMethodInfo = matches.get(i);
            if (superMethodInfo.getParameters().length != thisMethodInfo.getParameters().length) continue;
            paramTypes = paramTypes == null ? this.removeGenericMethodParameters(thisMethodInfo) : paramTypes;
            IType[] superParamTypes = this.removeGenericMethodParameters(superMethodInfo);
            if (!this.argsEqual(superParamTypes, paramTypes)) continue;
            if (replace) {
                methods.set(methods.indexOf(superMethodInfo), thisMethodInfo);
            }
            return;
        }
        methods.add(thisMethodInfo);
    }

    private IType[] removeGenericMethodParameters(IMethodInfo thisMethodInfo) {
        IGenericTypeVariable[] typeVariables;
        IParameterInfo[] parameters = thisMethodInfo.getParameters();
        IType[] paramTypes = new IType[parameters.length];
        ArrayList<IType> methodTypeVars = null;
        if (thisMethodInfo instanceof IGenericMethodInfo && (typeVariables = ((IGenericMethodInfo)((Object)thisMethodInfo)).getTypeVariables()) != null && typeVariables.length > 0) {
            methodTypeVars = new ArrayList<IType>();
            for (IGenericTypeVariable typeVariable : typeVariables) {
                ITypeVariableType typeVarType = typeVariable.getTypeVariableDefinition().getType();
                methodTypeVars.add(typeVarType);
            }
        }
        for (int i = 0; i < parameters.length; ++i) {
            IParameterInfo parameter = parameters[i];
            IType featureType = parameter.getFeatureType();
            if (methodTypeVars != null) {
                featureType = TypeSystem.boundTypes(featureType, methodTypeVars);
            }
            paramTypes[i] = featureType;
        }
        return paramTypes;
    }

    protected boolean areMethodParamsEqual(IType thisMethodParamType, IType superMethodParamType) {
        return thisMethodParamType.equals(superMethodParamType);
    }

    private boolean argsEqual(IType[] parameters, IType[] parameters1) {
        if (parameters.length == parameters1.length) {
            for (int i = 0; i < parameters.length; ++i) {
                IType parameter = parameters[i];
                if (this.areMethodParamsEqual(parameter, parameters1[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this._typeInfo.getOwnersType().getName();
    }

    private static enum InitState {
        NotInitialized,
        Initializing,
        ERROR,
        Initialized;

    }
}

