/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import java.net.URL;

public interface ILocationInfo {
    public static final ILocationInfo EMPTY = new ILocationInfo(){

        @Override
        public boolean hasLocation() {
            return false;
        }

        @Override
        public int getOffset() {
            return -1;
        }

        @Override
        public int getTextLength() {
            return -1;
        }

        @Override
        public int getLine() {
            return -1;
        }

        @Override
        public int getColumn() {
            return -1;
        }

        @Override
        public URL getFileUrl() {
            return null;
        }
    };

    public boolean hasLocation();

    public int getOffset();

    public int getTextLength();

    public int getLine();

    public int getColumn();

    default public boolean contains(int offset) {
        return this.getOffset() <= offset && this.getOffset() + this.getTextLength() > offset;
    }

    public URL getFileUrl();
}

