/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IMethodCallHandler;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.ScriptabilityModifier;
import gw.lang.reflect.SimpleParameterInfo;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.JavaExceptionInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleMethodInfo
extends BaseFeatureInfo
implements IMethodInfo {
    private IJavaClassMethod _method;
    private ScriptabilityModifier _modifier;
    private ArrayList<IExceptionInfo> _exceptions;
    private IMethodCallHandler _callHandler;
    private IParameterInfo[] _paramInfo;

    public SimpleMethodInfo(ScriptabilityModifier modifier, IJavaClassInfo clazz, String methodName, IJavaClassInfo ... paramTypes) {
        super(clazz.getJavaType());
        IJavaClassInfo[] exceptionTypes;
        this._modifier = modifier;
        try {
            this._method = clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this._exceptions = new ArrayList();
        for (IJavaClassInfo aClass : exceptionTypes = this._method.getExceptionTypes()) {
            this._exceptions.add(new JavaExceptionInfo(this, aClass, null));
        }
        this._callHandler = new IMethodCallHandler(){

            @Override
            public Object handleCall(Object ctx, Object ... args) {
                try {
                    return SimpleMethodInfo.this._method.invoke(ctx, args);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ArrayList<SimpleParameterInfo> list = new ArrayList<SimpleParameterInfo>();
        for (IJavaClassInfo aClass : paramTypes) {
            list.add(new SimpleParameterInfo(this, aClass.getJavaType(), 0));
        }
        this._paramInfo = list.toArray(new IParameterInfo[list.size()]);
    }

    @Override
    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean isVisible(IScriptabilityModifier constraint) {
        return this._modifier.satisfiesConstraint(constraint);
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this._method.getModifiers());
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public IParameterInfo[] getParameters() {
        return this._paramInfo;
    }

    @Override
    public IType getReturnType() {
        return this._method.getReturnType();
    }

    @Override
    public IMethodCallHandler getCallHandler() {
        return this._callHandler;
    }

    @Override
    public String getReturnDescription() {
        return "";
    }

    @Override
    public List<IExceptionInfo> getExceptions() {
        return this._exceptions;
    }
}

