/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.features;

import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.IPropertyReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PropertyReference<R, T>
extends FeatureReference<R, T>
implements IPropertyReference<R, T> {
    private IPropertyInfo _pi;
    private IType _rootType;

    public PropertyReference(IType rootType, String property) {
        this._rootType = rootType;
        this._pi = PropertyReference.getPropertyInfo(rootType, property);
    }

    static IPropertyInfo getPropertyInfo(IType rootType, String propName) {
        ITypeInfo typeInfo = rootType.getTypeInfo();
        if (typeInfo instanceof IRelativeTypeInfo) {
            return ((IRelativeTypeInfo)typeInfo).getProperty(rootType, propName);
        }
        return typeInfo.getProperty(propName);
    }

    public T get(R ctx) {
        return (T)this._pi.getAccessor().getValue(ctx);
    }

    public void set(R ctx, T val) {
        this._pi.getAccessor().setValue(ctx, val);
    }

    @Override
    public IType getRootType() {
        return this._rootType;
    }

    @Override
    public IPropertyInfo getPropertyInfo() {
        return this._pi;
    }

    @Override
    protected Object evaluate(Iterator args) {
        Object ctx = null;
        if (!this._pi.isStatic()) {
            ctx = args.next();
        }
        return this._pi.getAccessor().getValue(ctx);
    }

    @Override
    public IFeatureInfo getFeatureInfo() {
        return this.getPropertyInfo();
    }

    @Override
    public List<IType> getFullArgTypes() {
        ArrayList<IType> lst = new ArrayList<IType>();
        if (!this._pi.isStatic()) {
            lst.add(this._pi.getOwnersType());
        }
        return lst;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyReference that = (PropertyReference)o;
        if (this._pi != null ? !this._pi.equals(that._pi) : that._pi != null) {
            return false;
        }
        return !(this._rootType != null ? !this._rootType.equals(that._rootType) : that._rootType != null);
    }

    public int hashCode() {
        int result = this._pi != null ? this._pi.hashCode() : 0;
        result = 31 * result + (this._rootType != null ? this._rootType.hashCode() : 0);
        return result;
    }
}

