/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.lang.parser.Keyword;

public enum ClassType {
    Enhancement,
    Program,
    Template,
    Eval,
    Class,
    Interface,
    Structure,
    Annotation,
    Enum,
    JavaClass,
    Unknown;


    public boolean isJava() {
        return this == JavaClass;
    }

    public boolean isGosu() {
        return this == Enhancement || this == Program || this == Template || this == Eval || this == Class || this == Interface || this == Structure || this == Annotation || this == Enum;
    }

    public static ClassType getFromFileName(String name) {
        if (name.endsWith(".java")) {
            return JavaClass;
        }
        if (name.endsWith(".gsx")) {
            return Enhancement;
        }
        if (name.endsWith(".gsp")) {
            return Program;
        }
        if (name.endsWith(".gst")) {
            return Template;
        }
        if (name.endsWith(".gs") || name.endsWith(".gr") || name.endsWith(".grs")) {
            return Class;
        }
        return Unknown;
    }

    public String getExt() {
        switch (this) {
            case Class: 
            case Enum: 
            case Interface: 
            case Structure: 
            case Annotation: {
                return ".gs";
            }
            case Program: {
                return ".gsp";
            }
            case Enhancement: {
                return ".gsx";
            }
            case Template: {
                return ".gst";
            }
            case JavaClass: {
                return ".java";
            }
        }
        return "";
    }

    public String keyword() {
        switch (this) {
            case Enhancement: {
                return Keyword.KW_enhancement.getName();
            }
            case Interface: {
                return Keyword.KW_interface.getName();
            }
            case Structure: {
                return Keyword.KW_structure.getName();
            }
            case Annotation: {
                return Keyword.KW_annotation.getName();
            }
            case Enum: {
                return Keyword.KW_enum.getName();
            }
            case Class: 
            case Program: 
            case Template: 
            case JavaClass: 
            case Eval: {
                return Keyword.KW_class.getName();
            }
        }
        return "<unknown>";
    }
}

