/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.interval;

import gw.lang.reflect.interval.NumberInterval;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BigDecimalInterval
extends NumberInterval<BigDecimal, BigDecimalInterval> {
    public BigDecimalInterval(BigDecimal left, BigDecimal right) {
        this(left, right, BigDecimal.ONE, true, true, false);
    }

    public BigDecimalInterval(BigDecimal left, BigDecimal right, BigDecimal step, boolean bLeftClosed, boolean bRightClosed, boolean bReverse) {
        super(left, right, step, bLeftClosed, bRightClosed, bReverse);
        if (step.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + step);
        }
    }

    @Override
    public Iterator<BigDecimal> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<BigDecimal> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public BigDecimal getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        BigDecimal value = ((BigDecimal)this.getLeftEndpoint()).add(((BigDecimal)this.getStep()).multiply(BigDecimal.valueOf(iStepIndex)));
        int iComp = value.compareTo((BigDecimal)this.getRightEndpoint());
        if (this.isRightClosed() ? iComp <= 0 : iComp < 0) {
            return value;
        }
        return null;
    }

    @Override
    public BigDecimal getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        BigDecimal value = ((BigDecimal)this.getRightEndpoint()).subtract(((BigDecimal)this.getStep()).multiply(BigDecimal.valueOf(iStepIndex)));
        int iComp = value.compareTo((BigDecimal)this.getLeftEndpoint());
        if (this.isLeftClosed() ? iComp >= 0 : iComp > 0) {
            return value;
        }
        return null;
    }

    private class ReverseIterator
    implements Iterator<BigDecimal> {
        private BigDecimal _csr;

        public ReverseIterator() {
            this._csr = (BigDecimal)BigDecimalInterval.this.getRightEndpoint();
            if (!BigDecimalInterval.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int iComp = this._csr.compareTo((BigDecimal)BigDecimalInterval.this.getLeftEndpoint());
            return iComp > 0 || BigDecimalInterval.this.isLeftClosed() && iComp == 0;
        }

        @Override
        public BigDecimal next() {
            int iComp = this._csr.compareTo((BigDecimal)BigDecimalInterval.this.getLeftEndpoint());
            if (iComp < 0 || !BigDecimalInterval.this.isLeftClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            BigDecimal ret = this._csr;
            this._csr = this._csr.subtract((BigDecimal)BigDecimalInterval.this.getStep());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ForwardIterator
    implements Iterator<BigDecimal> {
        private BigDecimal _csr;

        public ForwardIterator() {
            this._csr = (BigDecimal)BigDecimalInterval.this.getLeftEndpoint();
            if (!BigDecimalInterval.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int iComp = this._csr.compareTo((BigDecimal)BigDecimalInterval.this.getRightEndpoint());
            return iComp < 0 || BigDecimalInterval.this.isRightClosed() && iComp == 0;
        }

        @Override
        public BigDecimal next() {
            int iComp = this._csr.compareTo((BigDecimal)BigDecimalInterval.this.getRightEndpoint());
            if (iComp > 0 || !BigDecimalInterval.this.isRightClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            BigDecimal ret = this._csr;
            this._csr = this._csr.add((BigDecimal)BigDecimalInterval.this.getStep());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

