/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java;

import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.ErrorJavaClassInfo;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.module.IModule;
import gw.util.GosuObjectUtil;
import java.io.Serializable;

public interface IJavaClassType
extends Serializable {
    public static final IJavaClassInfo[] EMPTY_ARRAY = new IJavaClassInfo[0];
    public static final ErrorJavaClassInfo NULL_TYPE = new ErrorJavaClassInfo();
    public static final ErrorJavaClassInfo ERROR_TYPE = new ErrorJavaClassInfo();

    public IType getActualType(TypeVarToTypeMap var1);

    public IType getActualType(TypeVarToTypeMap var1, boolean var2);

    public IJavaClassType getConcreteType();

    public String getName();

    public String getSimpleName();

    public boolean isArray();

    public IJavaClassType getComponentType();

    public IModule getModule();

    public String getNamespace();

    default public boolean isAssignableFrom(IJavaClassType from) {
        if (this.equals(from) || GosuObjectUtil.equals(this.getConcreteType(), from)) {
            return true;
        }
        IType actualFrom = from.getActualType(TypeVarToTypeMap.EMPTY_MAP);
        IType actualTo = this.getActualType(TypeVarToTypeMap.EMPTY_MAP);
        return actualTo != null && actualFrom != null && actualTo.isAssignableFrom(actualFrom) || this.getConcreteType().getActualType(TypeVarToTypeMap.EMPTY_MAP).isAssignableFrom(actualFrom);
    }

    public static boolean equals(IJavaClassType thisObj, Object that) {
        if (!(that instanceof IJavaClassType)) {
            return false;
        }
        if (thisObj.isArray()) {
            return ((IJavaClassType)that).isArray() && thisObj.getComponentType().equals(((IJavaClassType)that).getComponentType());
        }
        return thisObj.getName().equals(((IJavaClassType)that).getName()) && thisObj.getModule().equals(((IJavaClassType)that).getModule());
    }

    public static int hashCode(IJavaClassType thisObj) {
        return thisObj.isArray() ? thisObj.getComponentType().hashCode() : thisObj.getName().hashCode() * 31 + thisObj.getModule().hashCode();
    }
}

