/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.json;

import gw.lang.reflect.json.Token;
import gw.lang.reflect.json.TokenType;
import java.io.IOException;
import java.io.Reader;

final class Tokenizer {
    private Reader source;
    private int line;
    private int column;
    private char ch;

    public Tokenizer(Reader source) {
        this.source = source;
        this.line = 1;
        this.column = 0;
        this.nextChar();
    }

    public Token next() {
        Token T;
        this.eatWhiteSpace();
        switch (this.ch) {
            case '\"': 
            case '\'': {
                T = this.consumeString(this.ch);
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                T = this.consumeNumber();
                break;
            }
            case '{': {
                T = new Token(TokenType.LCURLY, "{", this.line, this.column);
                this.nextChar();
                break;
            }
            case '}': {
                T = new Token(TokenType.RCURLY, "}", this.line, this.column);
                this.nextChar();
                break;
            }
            case '[': {
                T = new Token(TokenType.LSQUARE, "[", this.line, this.column);
                this.nextChar();
                break;
            }
            case ']': {
                T = new Token(TokenType.RSQUARE, "]", this.line, this.column);
                this.nextChar();
                break;
            }
            case ',': {
                T = new Token(TokenType.COMMA, ",", this.line, this.column);
                this.nextChar();
                break;
            }
            case ':': {
                T = new Token(TokenType.COLON, ":", this.line, this.column);
                this.nextChar();
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                T = this.consumeConstant();
                break;
            }
            case '\u0000': {
                T = new Token(TokenType.EOF, "EOF", this.line, this.column);
                break;
            }
            default: {
                T = new Token(TokenType.ERROR, String.valueOf(this.ch), this.line, this.column);
                this.nextChar();
            }
        }
        return T;
    }

    private Token consumeString(char quote) {
        StringBuilder sb = new StringBuilder();
        int l = this.line;
        int c = this.column;
        this.nextChar();
        block9: while (this.moreChars() && this.ch != quote) {
            if (this.ch == '\\') {
                this.nextChar();
                switch (this.ch) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append(this.ch);
                        this.nextChar();
                        continue block9;
                    }
                    case 'b': {
                        sb.append('\b');
                        this.nextChar();
                        continue block9;
                    }
                    case 'f': {
                        sb.append('\f');
                        this.nextChar();
                        continue block9;
                    }
                    case 'n': {
                        sb.append('\n');
                        this.nextChar();
                        continue block9;
                    }
                    case 'r': {
                        sb.append('\r');
                        this.nextChar();
                        continue block9;
                    }
                    case 't': {
                        sb.append('\t');
                        this.nextChar();
                        continue block9;
                    }
                    case 'u': {
                        this.nextChar();
                        int u = 0;
                        for (int i = 0; i < 4; ++i) {
                            if (this.isHexDigit(this.ch)) {
                                u = u * 16 + this.ch - 48;
                                if (this.ch >= 'A') {
                                    u -= 7;
                                }
                            } else {
                                Token T = new Token(TokenType.ERROR, sb.toString(), this.line, this.column);
                                this.nextChar();
                                return T;
                            }
                            this.nextChar();
                        }
                        sb.append((char)u);
                        continue block9;
                    }
                }
                Token T = new Token(TokenType.ERROR, sb.toString(), this.line, this.column);
                this.nextChar();
                return T;
            }
            sb.append(this.ch);
            this.nextChar();
        }
        Token T = this.ch == quote ? new Token(TokenType.STRING, sb.toString(), l, c) : new Token(TokenType.ERROR, sb.toString(), this.line, this.column);
        this.nextChar();
        return T;
    }

    private Token consumeNumber() {
        boolean err;
        StringBuilder sb = new StringBuilder();
        int l = this.line;
        int c = this.column;
        boolean isDouble = false;
        if (this.ch == '-') {
            sb.append(this.ch);
            this.nextChar();
        }
        if (this.ch != '0') {
            err = this.consumeDigits(sb);
            if (err) {
                return new Token(TokenType.ERROR, sb.toString(), this.line, this.column);
            }
        } else {
            sb.append(this.ch);
            this.nextChar();
        }
        if (this.ch == '.') {
            isDouble = true;
            sb.append(this.ch);
            this.nextChar();
            err = this.consumeDigits(sb);
            if (err) {
                return new Token(TokenType.ERROR, sb.toString(), this.line, this.column);
            }
        }
        if (this.ch == 'E' || this.ch == 'e') {
            isDouble = true;
            sb.append(this.ch);
            this.nextChar();
            if (this.ch == '-') {
                sb.append(this.ch);
                this.nextChar();
            } else if (this.ch == '+') {
                sb.append(this.ch);
                this.nextChar();
            }
            err = this.consumeDigits(sb);
            if (err) {
                return new Token(TokenType.ERROR, sb.toString(), this.line, this.column);
            }
        }
        Token T = isDouble ? new Token(TokenType.DOUBLE, sb.toString(), l, c) : new Token(TokenType.INTEGER, sb.toString(), l, c);
        return T;
    }

    private boolean consumeDigits(StringBuilder sb) {
        boolean err = false;
        if (this.isDigit(this.ch)) {
            while (this.moreChars() && this.isDigit(this.ch)) {
                sb.append(this.ch);
                this.nextChar();
            }
        } else {
            err = true;
        }
        return err;
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    private Token consumeConstant() {
        StringBuilder sb = new StringBuilder();
        int l = this.line;
        int c = this.column;
        do {
            sb.append(this.ch);
            this.nextChar();
        } while (this.moreChars() && (this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z'));
        String str = sb.toString();
        TokenType type = Token.constants.get(str);
        Token T = type == null ? new Token(TokenType.ERROR, str, l, c) : new Token(type, str, l, c);
        return T;
    }

    private void eatWhiteSpace() {
        while (this.moreChars() && (this.ch == '\t' || this.ch == '\n' || this.ch == '\r' || this.ch == ' ')) {
            this.nextChar();
        }
    }

    private void nextChar() {
        int c;
        try {
            c = this.source.read();
        }
        catch (IOException e) {
            c = -1;
        }
        if (c == 10) {
            this.column = 0;
            ++this.line;
        } else if (c != -1) {
            ++this.column;
        } else {
            c = 0;
        }
        this.ch = (char)c;
    }

    private boolean moreChars() {
        return this.ch != '\u0000';
    }
}

