/*
 * Decompiled with CFR 0.152.
 */
package gw.util.perf.codestats;

import gw.util.StreamUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FileInfo {
    public String extension;
    public int fileCount;
    public int totalLines;
    public int codeLines;

    public FileInfo(String extension) {
        this.extension = extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File file) throws IOException {
        ++this.fileCount;
        BufferedReader reader = new BufferedReader(StreamUtil.getInputStreamReader(new FileInputStream(file)));
        try {
            String s = reader.readLine();
            while (s != null) {
                ++this.totalLines;
                if ((s = s.trim()).length() != 0 && !s.equals(Character.valueOf('{')) && !s.equals(Character.valueOf('}'))) {
                    ++this.codeLines;
                }
                s = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            StreamUtil.close(reader);
            throw throwable;
        }
        StreamUtil.close(reader);
    }

    public void printInfo() {
        System.out.println(this.fileCount + " " + this.extension.substring(1).toUpperCase() + " files: " + this.totalLines + "/" + this.codeLines + " lines");
    }

    public void add(FileInfo fileInfo) {
        this.fileCount += fileInfo.fileCount;
        this.totalLines += fileInfo.totalLines;
        this.codeLines += fileInfo.codeLines;
    }
}

