/*
 * Decompiled with CFR 0.152.
 */
package gw.util.perf.objectsize;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class UnmodifiableArraySet<T>
extends AbstractSet<T> {
    private Object[] array;

    public UnmodifiableArraySet(Set<T> set) {
        this.array = new Object[set.size()];
        int i = 0;
        for (T o : set) {
            this.array[i] = o;
            ++i;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < UnmodifiableArraySet.this.array.length;
            }

            @Override
            public T next() {
                Object v = UnmodifiableArraySet.this.array[this.i];
                ++this.i;
                return v;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.array.length;
    }
}

