/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.fs.IDirectory;
import gw.lang.gosuc.GosucDependency;
import gw.lang.gosuc.GosucProjectParser;
import gw.lang.gosuc.GosucUtil;
import gw.lang.parser.IToken;
import gw.lang.reflect.module.INativeModule;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GosucModule
implements INativeModule,
Serializable {
    private String _name;
    private List<String> _allSourceRoots = new ArrayList<String>();
    private List<String> _excludedRoots;
    private List<String> _classpath;
    private List<String> _backingSourcePath;
    private String _outputPath;
    private List<GosucDependency> _dependencies;

    public GosucModule(String name, List<String> allSourceRoots, List<String> classpath, List<String> backingSourcePath, String outputPath, List<GosucDependency> dependencies, List<String> excludedRoots) {
        for (String sourceRoot : allSourceRoots) {
            if (sourceRoot.endsWith(".jar")) continue;
            this._allSourceRoots.add(this.convertToUri(sourceRoot));
        }
        this._excludedRoots = new ArrayList<String>();
        this.makeUris(excludedRoots, this._excludedRoots);
        this._classpath = new ArrayList<String>();
        this.makeUris(classpath, this._classpath);
        this._backingSourcePath = new ArrayList<String>();
        this.makeUris(backingSourcePath, this._backingSourcePath);
        this._outputPath = this.convertToUri(outputPath);
        this._dependencies = dependencies;
        this._name = name;
    }

    private void makeUris(List<String> from, List<String> to) {
        for (String path : from) {
            to.add(this.convertToUri(path));
        }
    }

    private String convertToUri(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                return file.getAbsoluteFile().toURI().toString();
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        try {
            URI uri = URI.create(filePath);
            if (!uri.isAbsolute()) {
                filePath = new File(filePath).getAbsoluteFile().toURI().toString();
            }
        }
        catch (Exception e) {
            filePath = new File(filePath).getAbsoluteFile().toURI().toString();
        }
        return filePath;
    }

    public List<String> getAllSourceRoots() {
        return this._allSourceRoots;
    }

    public List<String> getExcludedRoots() {
        return this._excludedRoots;
    }

    public List<String> getClasspath() {
        return this._classpath;
    }

    public List<String> getBackingSourcePath() {
        return this._backingSourcePath;
    }

    public List<GosucDependency> getDependencies() {
        return this._dependencies;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public Object getNativeModule() {
        return this;
    }

    @Override
    public IDirectory getOutputPath() {
        return this._outputPath != null ? GosucUtil.getDirectoryForPath(this._outputPath) : null;
    }

    public String write() {
        return this.getName() + " {\n  sourcepath {\n" + this.writePath(this.getAllSourceRoots()) + "  }\n  excludedpath {\n" + this.writePath(this.getExcludedRoots()) + "  }\n  classpath {\n" + this.writePath(this.getClasspath()) + "  }\n  backingsource {\n" + this.writePath(this.getBackingSourcePath()) + "  }\n  outpath {\n" + this.writeOutputPath() + "  }\n  deps {\n" + this.writeDependencies() + "  }\n}\n";
    }

    private String writePath(List<String> paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            sb.append("    ").append("\"").append(path).append("\",\n");
        }
        return sb.toString();
    }

    private String writeOutputPath() {
        return this._outputPath != null ? "    \"" + this._outputPath + "\"\n" : "    \"\"\n";
    }

    private String writeDependencies() {
        StringBuilder sb = new StringBuilder();
        for (GosucDependency dep : this.getDependencies()) {
            sb.append("    ").append(dep.write()).append("\n");
        }
        return sb.toString();
    }

    public static GosucModule parse(GosucProjectParser parser) {
        IToken t = parser.getTokenizer().getCurrentToken();
        parser.verify(parser.match(null, -5, false), "Expecting module name");
        String name = t.getStringValue();
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin module definition");
        List<String> sourcepaths = GosucModule.parsePaths("sourcepath", parser);
        List<String> excludedRoots = GosucModule.parsePaths("excludedpath", parser);
        List<String> classpath = GosucModule.parseClasspath(parser);
        List<String> backingSourcePath = GosucModule.parseBackingSourcePath(parser);
        String outputPath = GosucModule.parseOutputPath(parser);
        List<GosucDependency> deps = GosucModule.parseDependencies(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close module definition");
        return new GosucModule(name, sourcepaths, classpath, backingSourcePath, outputPath, deps, excludedRoots);
    }

    private static List<GosucDependency> parseDependencies(GosucProjectParser parser) {
        parser.verify(parser.matchWord("deps", false), "Expecting keyword 'deps'");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin deps list");
        List<GosucDependency> deps = GosucModule.parseDependenciesList(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close deps list");
        return deps;
    }

    private static List<GosucDependency> parseDependenciesList(GosucProjectParser parser) {
        ArrayList<GosucDependency> deps = new ArrayList<GosucDependency>();
        while (parser.match(null, -5, true)) {
            deps.add(GosucDependency.parse(parser));
        }
        return deps;
    }

    private static List<String> parseClasspath(GosucProjectParser parser) {
        parser.verify(parser.matchWord("classpath", false), "Expecting keyword 'classpath'");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin classpath list");
        List<String> classpaths = GosucModule.parsePathList(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close classpath list");
        return classpaths;
    }

    private static List<String> parseBackingSourcePath(GosucProjectParser parser) {
        if (parser.matchWord("backingsource", false)) {
            parser.verify(parser.match(null, 123, false), "Expecting '{' to begin backingsource list");
            List<String> backingSourcePath = GosucModule.parsePathList(parser);
            parser.verify(parser.match(null, 125, false), "Expecting '}' to close backingsource list");
            return backingSourcePath;
        }
        return Collections.emptyList();
    }

    private static List<String> parsePaths(String word, GosucProjectParser parser) {
        parser.verify(parser.matchWord(word, false), "Expecting keyword 'sourcepath'");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin " + word + " list");
        List<String> sourcepaths = GosucModule.parsePathList(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close " + word + " list");
        return sourcepaths;
    }

    private static List<String> parsePathList(GosucProjectParser parser) {
        ArrayList<String> paths = new ArrayList<String>();
        IToken t = parser.getTokenizer().getCurrentToken();
        while (parser.match(null, 34, false)) {
            paths.add(t.getStringValue());
            if (!parser.match(null, 44, false)) break;
            t = parser.getTokenizer().getCurrentToken();
        }
        return paths;
    }

    private static String parseOutputPath(GosucProjectParser parser) {
        parser.verify(parser.matchWord("outpath", false), "Expecting keyword 'outpath'");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin outpath list");
        IToken t = parser.getTokenizer().getCurrentToken();
        parser.verify(parser.match(null, 34, false), "Expecting quoted path");
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close outpath list");
        String value = t.getStringValue();
        return value.trim().isEmpty() ? null : value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GosucModule that = (GosucModule)o;
        if (!this._allSourceRoots.equals(that._allSourceRoots)) {
            return false;
        }
        if (!this._excludedRoots.equals(that._excludedRoots)) {
            return false;
        }
        if (!this._classpath.equals(that._classpath)) {
            return false;
        }
        if (!this._backingSourcePath.equals(that._backingSourcePath)) {
            return false;
        }
        if (!this._dependencies.equals(that._dependencies)) {
            return false;
        }
        if (!this._name.equals(that._name)) {
            return false;
        }
        return !(this._outputPath == null ? that._outputPath != null : !this._outputPath.equals(that._outputPath));
    }

    public int hashCode() {
        int result = this._name.hashCode();
        result = 31 * result + this._allSourceRoots.hashCode();
        result = 31 * result + this._excludedRoots.hashCode();
        result = 31 * result + this._classpath.hashCode();
        result = 31 * result + this._backingSourcePath.hashCode();
        result = 31 * result + (this._outputPath != null ? this._outputPath.hashCode() : 0);
        result = 31 * result + this._dependencies.hashCode();
        return result;
    }
}

