/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.fs.IFile;
import gw.lang.parser.ISource;
import gw.lang.parser.StringSource;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.asm.AsmClass;
import gw.util.GosuClassUtil;
import gw.util.StreamUtil;
import java.io.IOException;

public class AsmBackingSourceFileHandle
implements ISourceFileHandle {
    private AsmClass _asmClass;
    private boolean _bTest;
    private IFile _file;
    private int _iOffset;
    private int _iEnd;

    public AsmBackingSourceFileHandle(IFile file, AsmClass asmClass, boolean bTest) {
        this._bTest = bTest;
        this._file = file;
        this._asmClass = asmClass;
    }

    @Override
    public ISource getSource() {
        try {
            return new StringSource(StreamUtil.getContent(StreamUtil.getInputStreamReader(this._file.openInputStream())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getParentType() {
        return null;
    }

    @Override
    public String getNamespace() {
        return GosuClassUtil.getPackage(this._asmClass.getName());
    }

    @Override
    public String getFilePath() {
        return this._file.getPath().getFileSystemPathString();
    }

    @Override
    public IFile getFile() {
        return this._file;
    }

    @Override
    public boolean isTestClass() {
        return this._bTest;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isStandardPath() {
        return true;
    }

    @Override
    public boolean isIncludeModulePath() {
        return false;
    }

    @Override
    public void cleanAfterCompile() {
    }

    @Override
    public ClassType getClassType() {
        return ClassType.getFromFileName(this._asmClass.getName());
    }

    @Override
    public String getTypeNamespace() {
        String namespace = this.getNamespace();
        if (namespace.isEmpty()) {
            namespace = "default";
        }
        return namespace;
    }

    @Override
    public String getRelativeName() {
        return this._asmClass.getSimpleName();
    }

    @Override
    public void setOffset(int iOffset) {
        this._iOffset = iOffset;
    }

    @Override
    public int getOffset() {
        return this._iOffset;
    }

    @Override
    public void setEnd(int iEnd) {
        this._iEnd = iEnd;
    }

    @Override
    public int getEnd() {
        return this._iEnd;
    }

    @Override
    public String getFileName() {
        return this._file.getName();
    }

    public String toString() {
        return this._file.getPath().getPathString();
    }
}

