/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.json;

import gw.lang.reflect.json.TokenType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class Token {
    private final TokenType type;
    private final String string;
    private final int line;
    private final int column;
    static final Map<String, TokenType> constants = Token.initializeConstants();

    public Token(TokenType type, String string, int line, int column) {
        this.type = type;
        this.string = string;
        this.line = line;
        this.column = column;
    }

    private static Map<String, TokenType> initializeConstants() {
        HashMap<String, TokenType> map = new HashMap<String, TokenType>();
        map.put("true", TokenType.TRUE);
        map.put("false", TokenType.FALSE);
        map.put("null", TokenType.NULL);
        return Collections.unmodifiableMap(map);
    }

    public String getString() {
        return this.string;
    }

    public TokenType getType() {
        return this.type;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return this.string + " : " + this.type;
    }

    public boolean isValueType() {
        return this.type == TokenType.LCURLY || this.type == TokenType.LSQUARE || this.type == TokenType.INTEGER || this.type == TokenType.DOUBLE || this.type == TokenType.STRING || this.type == TokenType.TRUE || this.type == TokenType.FALSE || this.type == TokenType.NULL;
    }
}

