/*
 * Decompiled with CFR 0.152.
 */
package gw.util.concurrent;

import gw.lang.reflect.TypeSystem;
import java.util.concurrent.locks.Lock;

public abstract class LockingLazyVar<T> {
    protected static final Object NULL = new Object();
    private volatile T _val = null;
    private final Lock _lock;

    public LockingLazyVar() {
        this._lock = TypeSystem.getGlobalLock();
    }

    protected LockingLazyVar(Lock lock) {
        this._lock = lock;
    }

    public final T get() {
        T result = this._val;
        if (result == NULL) {
            return null;
        }
        if (result == null) {
            this._lock.lock();
            try {
                result = this._val;
                if (result == NULL) {
                    T t = null;
                    return t;
                }
                if (result == null) {
                    result = this.init();
                    this._val = result == null ? NULL : result;
                }
            }
            finally {
                this._lock.unlock();
            }
        }
        return result;
    }

    protected abstract T init();

    public final T clear() {
        T hold;
        this._lock.lock();
        try {
            hold = this._val;
            this._val = null;
        }
        finally {
            this._lock.unlock();
        }
        return hold;
    }

    public final void clearNoLock() {
        this._val = null;
    }

    protected void initDirectly(T val) {
        this._lock.lock();
        try {
            this._val = val;
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean isLoaded() {
        return this._val != null;
    }

    public static <Q> LockingLazyVar<Q> make(final LazyVarInit<Q> init) {
        return new LockingLazyVar<Q>(){

            @Override
            protected Q init() {
                return init.init();
            }
        };
    }

    public static <Q> LockingLazyVar<Q> make(Lock lock, final LazyVarInit<Q> init) {
        return new LockingLazyVar<Q>(lock){

            @Override
            protected Q init() {
                return init.init();
            }
        };
    }

    public static interface LazyVarInit<Q> {
        public Q init();
    }
}

