/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.physical;

import gw.fs.IFile;
import gw.fs.ResourcePath;
import gw.fs.physical.IPhysicalFileSystem;
import gw.fs.physical.PhysicalResourceImpl;
import gw.lang.UnstableAPI;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@UnstableAPI
public class PhysicalFileImpl
extends PhysicalResourceImpl
implements IFile {
    public PhysicalFileImpl(ResourcePath path, IPhysicalFileSystem backingFileSystem) {
        super(path, backingFileSystem);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.toJavaFile());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new FileOutputStream(this.toJavaFile());
    }

    @Override
    public OutputStream openOutputStreamForAppend() throws IOException {
        return new FileOutputStream(this.toJavaFile(), true);
    }

    @Override
    public String getExtension() {
        int lastDot = this.getName().lastIndexOf(".");
        if (lastDot != -1) {
            return this.getName().substring(lastDot + 1);
        }
        return "";
    }

    @Override
    public String getBaseName() {
        int lastDot = this.getName().lastIndexOf(".");
        if (lastDot != -1) {
            return this.getName().substring(0, lastDot);
        }
        return this.getName();
    }

    @Override
    public boolean create() {
        try {
            return this.toJavaFile().createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

