/*
 * Decompiled with CFR 0.152.
 */
package gw.lang;

import gw.util.GosuExceptionUtil;
import gw.util.GosuStringUtil;
import gw.util.StreamUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import java.util.StringTokenizer;

public class GosuVersion
implements Comparable<GosuVersion> {
    public static final String RESOURCE_PATH = "gw/lang/gosu-version.properties";
    private final int _major;
    private final int _minor;
    private final int _incremental;
    private final int _buildNum;
    private final String _qualifier;

    /*
     * Loose catch block
     */
    public static GosuVersion parse(Reader in) {
        String qualifier;
        int incremental;
        int minor;
        int major;
        block16: {
            String majorProp;
            Properties props;
            block15: {
                props = new Properties();
                props.load(in);
                majorProp = (String)props.get("gosu.version.major");
                int dotIndex = majorProp.indexOf(46);
                if (dotIndex < 0) break block15;
                int major2 = Integer.parseInt(majorProp.substring(0, dotIndex));
                int minor2 = Integer.parseInt(majorProp.substring(dotIndex + 1));
                int incremental2 = Integer.parseInt((String)props.get("gosu.version.minor"));
                String qualifier2 = (String)props.get("gosu.version.aux");
                GosuVersion gosuVersion = new GosuVersion(major2, minor2, incremental2, qualifier2);
                try {
                    StreamUtil.close(in);
                }
                catch (IOException e) {
                    System.err.println("Could not close version properties stream");
                }
                return gosuVersion;
            }
            major = Integer.parseInt(majorProp);
            minor = Integer.parseInt((String)props.get("gosu.version.minor"));
            incremental = Integer.parseInt((String)props.get("gosu.version.incremental"));
            int build = Integer.parseInt((String)props.get("gosu.version.build"));
            qualifier = (String)props.get("gosu.version.qualifier");
            if (build > 0 && !GosuStringUtil.isEmpty(qualifier)) {
                throw new IllegalArgumentException("build number non-zero and qualifier non-empty, can only have one or the other");
            }
            if (build <= 0) break block16;
            GosuVersion gosuVersion = new GosuVersion(major, minor, incremental, build);
            try {
                StreamUtil.close(in);
            }
            catch (IOException e) {
                System.err.println("Could not close version properties stream");
            }
            return gosuVersion;
        }
        GosuVersion gosuVersion = new GosuVersion(major, minor, incremental, qualifier);
        try {
            StreamUtil.close(in);
        }
        catch (IOException e) {
            System.err.println("Could not close version properties stream");
        }
        return gosuVersion;
        catch (IOException e) {
            try {
                throw GosuExceptionUtil.forceThrow(e);
            }
            catch (Throwable throwable) {
                try {
                    StreamUtil.close(in);
                }
                catch (IOException e2) {
                    System.err.println("Could not close version properties stream");
                }
                throw throwable;
            }
        }
    }

    public static GosuVersion parse(String version) {
        String part1;
        int majorVersion = 0;
        int minorVersion = 0;
        int incrementalVersion = 0;
        int buildNumber = 0;
        String qualifier = null;
        int index = version.indexOf("-");
        String part2 = null;
        if (index < 0) {
            part1 = version;
        } else {
            part1 = version.substring(0, index);
            part2 = version.substring(index + 1);
        }
        if (part2 != null) {
            try {
                if (part2.length() == 1 || !part2.startsWith("0")) {
                    buildNumber = Integer.valueOf(part2);
                } else {
                    qualifier = part2;
                }
            }
            catch (NumberFormatException e) {
                qualifier = part2;
            }
        }
        if (part1.indexOf(".") < 0 && !part1.startsWith("0")) {
            try {
                majorVersion = Integer.valueOf(part1);
            }
            catch (NumberFormatException e) {
                qualifier = version;
                buildNumber = 0;
            }
        } else {
            boolean fallback = false;
            StringTokenizer tok = new StringTokenizer(part1, ".");
            try {
                majorVersion = GosuVersion.getNextIntegerToken(tok);
                if (tok.hasMoreTokens()) {
                    minorVersion = GosuVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    incrementalVersion = GosuVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    fallback = true;
                }
                if (part1.indexOf("..") >= 0 || part1.startsWith(".") || part1.endsWith(".")) {
                    fallback = true;
                }
            }
            catch (NumberFormatException e) {
                fallback = true;
            }
            if (fallback) {
                qualifier = version;
                majorVersion = 0;
                minorVersion = 0;
                incrementalVersion = 0;
                buildNumber = 0;
            }
        }
        return new GosuVersion(majorVersion, minorVersion, incrementalVersion, buildNumber, qualifier);
    }

    private static Integer getNextIntegerToken(StringTokenizer tok) {
        String s = tok.nextToken();
        if (s.length() > 1 && s.startsWith("0")) {
            throw new NumberFormatException("Number part has a leading 0: '" + s + "'");
        }
        return Integer.valueOf(s);
    }

    public GosuVersion(int major, int minor) {
        this(major, minor, 0, 0);
    }

    public GosuVersion(int major, int minor, int incremental) {
        this(major, minor, incremental, 0);
    }

    public GosuVersion(int major, int minor, int incremental, int buildNum) {
        this(major, minor, incremental, buildNum, null);
    }

    public GosuVersion(int major, int minor, int incremental, String qualifier) {
        this(major, minor, incremental, 0, GosuStringUtil.isEmpty(qualifier) ? null : qualifier);
    }

    private GosuVersion(int major, int minor, int incremental, int buildNum, String qualifier) {
        this._major = major;
        this._minor = minor;
        this._incremental = incremental;
        this._buildNum = buildNum;
        this._qualifier = qualifier;
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getIncremental() {
        return this._incremental;
    }

    public int getBuildNum() {
        return this._buildNum;
    }

    public String getQualifier() {
        return this._qualifier;
    }

    @Override
    public int compareTo(GosuVersion that) {
        int cmp = this._major - that.getMajor();
        if (cmp == 0 && (cmp = this._minor - that.getMinor()) == 0) {
            cmp = this._incremental - that.getIncremental();
            if (cmp == 0) {
                cmp = this._buildNum - that.getBuildNum();
            }
            if (cmp == 0) {
                if (this._qualifier != null && that.getQualifier() != null) {
                    cmp = this._qualifier.compareTo(that.getQualifier());
                } else {
                    if (this._qualifier != null && that.getQualifier() == null) {
                        return Integer.MAX_VALUE;
                    }
                    if (this._qualifier == null && that.getQualifier() != null) {
                        return Integer.MIN_VALUE;
                    }
                }
            }
        }
        return cmp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GosuVersion that = (GosuVersion)o;
        if (this._major != that.getMajor() || this._minor != that.getMinor() || this._incremental != that.getIncremental() || this._buildNum != that.getBuildNum()) {
            return false;
        }
        return !(this._qualifier != null ? !this._qualifier.equals(that._qualifier) : that._qualifier != null);
    }

    public int hashCode() {
        int result = this._major;
        result = 31 * result + this._minor;
        result = 31 * result + this._incremental;
        result = 31 * result + this._buildNum;
        result = 31 * result + (this._qualifier != null ? this._qualifier.hashCode() : 0);
        return result;
    }

    public String toMajorMinorString() {
        return this._major + "." + this._minor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._major).append('.').append(this._minor);
        if (this._incremental > 0) {
            sb.append('.').append(this._incremental);
        }
        if (this._buildNum > 0) {
            sb.append('-').append(this._buildNum);
        } else if (this._qualifier != null) {
            sb.append('-').append(this._qualifier);
        }
        return sb.toString();
    }
}

