/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.expression;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import java.util.List;

@UnstableAPI
public class IRMethodCallExpression
extends IRExpression {
    private String _name;
    private IRType _ownersType;
    private boolean _interface;
    private IRType _returnType;
    private List<IRType> _parameterTypes;
    private IRExpression _root;
    private List<IRExpression> _args;
    private boolean _isSpecial;
    private IRType _structureTypeOwner;

    public IRMethodCallExpression(String name, IRType ownersType, boolean isInterface, IRType returnType, List<IRType> parameterTypes, IRExpression root, List<IRExpression> args) {
        this._name = name;
        this._ownersType = ownersType;
        this._interface = isInterface;
        this._returnType = IRMethodCallExpression.maybeEraseStructuralType(ownersType, returnType);
        this._parameterTypes = this.maybeEraseStructuralTypes(ownersType, parameterTypes);
        this._root = root;
        this._args = args;
        if (root != null) {
            root.setParent(this);
        }
        for (IRExpression arg : args) {
            arg.setParent(this);
        }
    }

    public String getName() {
        return this._name;
    }

    public IRType getOwnersType() {
        return this._structureTypeOwner == null ? this._ownersType : this._structureTypeOwner;
    }

    public IRType getReturnType() {
        return this._returnType;
    }

    public List<IRType> getParameterTypes() {
        return this._parameterTypes;
    }

    public IRExpression getRoot() {
        return this._root;
    }

    public List<IRExpression> getArgs() {
        return this._args;
    }

    public boolean isInterface() {
        return this._interface;
    }

    public boolean isSpecial() {
        return this._isSpecial;
    }

    public void setSpecial(boolean special) {
        this._isSpecial = special;
    }

    @Override
    public IRType getType() {
        return this._returnType;
    }

    public void setStructuralTypeOwner(IRType gosuClassIRType) {
        this._structureTypeOwner = gosuClassIRType;
    }
}

