/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.coercers;

import gw.lang.GosuShop;
import gw.lang.parser.coercers.BaseCoercer;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;

public class FunctionFromInterfaceCoercer
extends BaseCoercer {
    private static FunctionFromInterfaceCoercer _instance = new FunctionFromInterfaceCoercer();

    public static FunctionFromInterfaceCoercer instance() {
        return _instance;
    }

    private FunctionFromInterfaceCoercer() {
    }

    @Override
    public boolean handlesNull() {
        return false;
    }

    @Override
    public Object coerceValue(IType typeToCoerceTo, Object value) {
        return value;
    }

    public static Object doCoercion(Class classToCoerceTo, Class ifaceClass, Object value) {
        Method abstractMethod = FunctionFromInterfaceCoercer.findSingleAbstractMethod(ifaceClass);
        return Proxy.newProxyInstance(classToCoerceTo.getClassLoader(), new Class[]{classToCoerceTo}, (proxy, method, args) -> {
            if (method.getName().startsWith("invoke")) {
                return abstractMethod.invoke(value, args);
            }
            return method.invoke(value, args);
        });
    }

    private static Method findSingleAbstractMethod(Class ifaceClass) {
        if (ifaceClass.isInterface()) {
            for (Method m : ifaceClass.getDeclaredMethods()) {
                if (!Modifier.isAbstract(m.getModifiers())) continue;
                return m;
            }
        } else {
            for (Class<?> iface : ifaceClass.getInterfaces()) {
                if (iface.getName().equals(IGosuObject.class.getName())) continue;
                for (Method m : iface.getDeclaredMethods()) {
                    if (!Modifier.isAbstract(m.getModifiers())) continue;
                    return m;
                }
            }
        }
        throw new IllegalStateException("No abstract interface method found for " + ifaceClass);
    }

    @Override
    public boolean isExplicitCoercion() {
        return false;
    }

    public static boolean areTypesCompatible(IFunctionType functionType, IType interfaceType) {
        if (interfaceType.isInterface() && interfaceType instanceof IJavaType) {
            IJavaType javaIntrinsicType = (IJavaType)interfaceType;
            MethodList list = javaIntrinsicType.getTypeInfo().getMethods();
            int nonObjectMethods = 0;
            IMethodInfo singleMethod = null;
            for (IMethodInfo iMethodInfo : list) {
                if (iMethodInfo.getOwnersType().equals(JavaTypes.OBJECT()) || !(iMethodInfo instanceof IJavaMethodInfo)) continue;
                ++nonObjectMethods;
                singleMethod = iMethodInfo;
            }
            if (nonObjectMethods == 1) {
                IFunctionType tempFunctionType = GosuShop.createFunctionType(singleMethod);
                return functionType.isAssignableFrom(tempFunctionType);
            }
        }
        return false;
    }

    @Override
    public int getPriority(IType to, IType from) {
        return 2;
    }
}

