/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.config.CommonServices;
import gw.lang.parser.ICoercer;
import gw.lang.parser.IExpression;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.TypeSystemAwareCache;
import gw.lang.parser.coercers.BasePrimitiveCoercer;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IConstructorType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IInvocableType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.MethodScore;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import gw.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MethodScorer {
    public static final int BOXED_COERCION_SCORE = 10;
    public static final int PRIMITIVE_COERCION_SCORE = 24;
    private static volatile MethodScorer INSTANCE = null;
    private final TypeSystemAwareCache<Pair<IType, IType>, Double> _typeScoreCache = TypeSystemAwareCache.make("Type Score Cache", 1000, key -> this._addToScoreForTypes(Collections.emptyList(), (IType)key.getFirst(), (IType)key.getSecond()));
    private final MethodScoreCache _methodScoreCache = new MethodScoreCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodScorer instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MethodScorer> clazz = MethodScorer.class;
        synchronized (MethodScorer.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MethodScorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private MethodScorer() {
    }

    public List<MethodScore> scoreMethods(List<IInvocableType> funcTypes, List<IType> argTypes) {
        ArrayList<MethodScore> scores = new ArrayList<MethodScore>();
        for (IInvocableType funcType : funcTypes) {
            scores.add(this.scoreMethod(null, null, funcType, Collections.emptyList(), argTypes, Collections.emptyList(), funcTypes.size() == 1, true));
        }
        Collections.sort(scores);
        return scores;
    }

    public MethodScore scoreMethod(IType callsiteEnclosingType, IType rootType, IInvocableType funcType, List<? extends IInvocableType> listFunctionTypes, List<IType> argTypes, List<IType> inferringTypes, boolean bSkipScoring, boolean bLookInCache) {
        MethodScore score = new MethodScore(rootType, callsiteEnclosingType);
        score.setValid(true);
        if (!bSkipScoring) {
            IInvocableType cachedFuncType = bLookInCache ? this.getCachedMethodScore(funcType, callsiteEnclosingType, rootType, argTypes) : null;
            if ((cachedFuncType = this.matchInOverloads(listFunctionTypes, cachedFuncType)) != null) {
                score.setRawFunctionType(cachedFuncType);
                score.setScore(0.0);
            } else {
                score.setRawFunctionType(funcType);
                score.incScore(this.scoreMethod(funcType, argTypes, inferringTypes));
            }
        } else {
            score.setRawFunctionType(funcType);
        }
        return score;
    }

    private IInvocableType matchInOverloads(List<? extends IInvocableType> listOverloads, IInvocableType cachedFuncType) {
        if (cachedFuncType == null) {
            return null;
        }
        for (IInvocableType iInvocableType : listOverloads) {
            if (!iInvocableType.equals(cachedFuncType)) continue;
            return iInvocableType;
        }
        return null;
    }

    public double scoreMethod(IInvocableType funcType, List<IType> argTypes, List<IType> inferringTypes) {
        int i;
        IType[] paramTypes = funcType.getParameterTypes();
        double score = 0.0;
        for (i = 0; i < argTypes.size(); ++i) {
            if (paramTypes.length <= i) {
                score += 128.0;
                continue;
            }
            IType argType = argTypes.get(i);
            if (funcType instanceof IBlockType) {
                score += this.addToScoreForTypes(inferringTypes, argType, paramTypes[i]);
                continue;
            }
            score += this.addToScoreForTypes(inferringTypes, paramTypes[i], argType);
        }
        for (i = argTypes.size(); i < paramTypes.length; ++i) {
            score += 127.0;
        }
        return score;
    }

    public double addToScoreForTypes(List<IType> inferringTypes, IType paramType, IType argType) {
        if (inferringTypes.isEmpty() || !(paramType instanceof IInvocableType)) {
            IType iType = paramType = inferringTypes.isEmpty() ? paramType : TypeSystem.boundTypes(paramType, inferringTypes);
            if (argType == paramType) {
                return 0.0;
            }
            return (Double)this._typeScoreCache.get(new Pair<IType, IType>(paramType, argType));
        }
        if (argType == paramType) {
            return 0.0;
        }
        return this._addToScoreForTypes(inferringTypes, paramType, argType);
    }

    public double _addToScoreForTypes(List<IType> inferringTypes, IType paramType, IType argType) {
        IType primitiveArgType;
        IType primitiveParamType;
        double score;
        if ((paramType = TypeSystem.boundTypes(paramType, inferringTypes)).equals(argType)) {
            score = 0.0;
        } else if (!paramType.isPrimitive() && argType == JavaTypes.pVOID()) {
            score = 1.0;
        } else if (this.arePrimitiveTypesCompatible(paramType, argType)) {
            score = BasePrimitiveCoercer.getPriorityOf(paramType, argType);
        } else if (TypeSystem.isBoxedTypeFor(paramType, argType) || TypeSystem.isBoxedTypeFor(argType, paramType)) {
            score = 10.0;
        } else if (argType.isPrimitive() && StandardCoercionManager.isBoxed(paramType) && this.arePrimitiveTypesCompatible(primitiveParamType = TypeSystem.getPrimitiveType(paramType), argType)) {
            score = 10 + BasePrimitiveCoercer.getPriorityOf(primitiveParamType, argType);
        } else if (StandardCoercionManager.isBoxed(argType) && paramType.isPrimitive() && this.arePrimitiveTypesCompatible(paramType, primitiveArgType = TypeSystem.getPrimitiveType(argType))) {
            score = 10 + BasePrimitiveCoercer.getPriorityOf(paramType, primitiveArgType);
        } else if (StandardCoercionManager.isBoxed(argType) && StandardCoercionManager.isBoxed(paramType) && this.arePrimitiveTypesCompatible(primitiveParamType = TypeSystem.getPrimitiveType(paramType), primitiveArgType = TypeSystem.getPrimitiveType(argType))) {
            score = 20 + BasePrimitiveCoercer.getPriorityOf(primitiveParamType, primitiveArgType);
        } else {
            IFunctionType funcType;
            int iFunctionToInterfacePenalty = 0;
            if (paramType.isInterface() && argType instanceof IInvocableType && (funcType = paramType.getFunctionalInterface()) != null) {
                paramType = funcType;
                iFunctionToInterfacePenalty = 2;
            }
            if (paramType instanceof IInvocableType && argType instanceof IInvocableType) {
                double degrees = this.addDegreesOfSeparation(paramType, argType, inferringTypes);
                int paramCountPlusReturn = Math.max(((IInvocableType)paramType).getParameterTypes().length, ((IInvocableType)argType).getParameterTypes().length) + 1;
                score = Math.min(117, ((int)degrees + paramCountPlusReturn - 1) / paramCountPlusReturn);
                score += (double)iFunctionToInterfacePenalty;
            } else {
                ICoercer iCoercer;
                IType boxedArgType;
                score = argType.isPrimitive() && argType != JavaTypes.pVOID() && !paramType.isPrimitive() && paramType.isAssignableFrom(boxedArgType = TypeSystem.getBoxType(argType)) ? 10.0 + this.addDegreesOfSeparation(paramType, boxedArgType, inferringTypes) : (paramType.isAssignableFrom(argType) ? (!(argType instanceof IInvocableType) ? this.addDegreesOfSeparation(paramType, argType, inferringTypes) : 125.0) : (StandardCoercionManager.isStructurallyAssignable(paramType, argType) ? 125.0 : ((iCoercer = CommonServices.getCoercionManager().findCoercer(paramType, argType, false)) != null ? (iCoercer instanceof BasePrimitiveCoercer ? (double)(24 + iCoercer.getPriority(paramType, argType)) : (double)(127 - iCoercer.getPriority(paramType, argType) - 1)) : 126.0)));
            }
        }
        return score;
    }

    private boolean arePrimitiveTypesCompatible(IType paramType, IType argType) {
        return StandardCoercionManager.arePrimitiveTypesAssignable(paramType, argType) || paramType.isPrimitive() && argType.isPrimitive() && paramType != JavaTypes.pBOOLEAN() && argType != JavaTypes.pBOOLEAN() && paramType != JavaTypes.pCHAR() && argType != JavaTypes.pCHAR() && paramType != JavaTypes.pVOID() && argType != JavaTypes.pVOID() && BasePrimitiveCoercer.losesInformation(argType, paramType) <= 1;
    }

    public double addDegreesOfSeparation(IType parameterType, IType exprType, List<IType> inferringTypes) {
        double degrees = this.addDegreesOfSeparation(parameterType, exprType instanceof IInvocableType ? Collections.singleton(exprType) : exprType.getAllTypesInHierarchy(), inferringTypes);
        double paramDegrees = this.addDegreesOfSeparationFromParameterization(parameterType, exprType, inferringTypes);
        return degrees += paramDegrees;
    }

    private double addDegreesOfSeparationFromParameterization(IType parameterType, IType exprType, List<IType> inferringTypes) {
        double paramDegrees;
        block4: {
            block3: {
                paramDegrees = 0.0;
                if (!parameterType.isParameterizedType()) break block3;
                IType mappedExprType = TypeSystem.findParameterizedType(exprType, this.getGenericType(parameterType));
                if (mappedExprType == null || !mappedExprType.isParameterizedType()) break block4;
                IType[] typeParameters = parameterType.getTypeParameters();
                IType[] mappedParams = mappedExprType.getTypeParameters();
                for (int i = 0; i < typeParameters.length; ++i) {
                    IType paramType = typeParameters[i];
                    IType mappedParam = mappedParams[i];
                    paramDegrees += this.addDegreesOfSeparation(paramType, mappedParam instanceof IInvocableType ? Collections.singleton(mappedParam) : mappedParam.getAllTypesInHierarchy(), inferringTypes);
                }
                break block4;
            }
            if (exprType.isParameterizedType()) {
                for (IType exprTypeParam : exprType.getTypeParameters()) {
                    paramDegrees += this.addDegreesOfSeparation((IType)JavaTypes.OBJECT(), exprTypeParam instanceof IInvocableType ? Collections.singleton(exprTypeParam) : exprTypeParam.getAllTypesInHierarchy(), inferringTypes);
                }
            }
        }
        return paramDegrees / 1000.0;
    }

    /*
     * WARNING - void declaration
     */
    public double addDegreesOfSeparation(IType parameterType, Set<? extends IType> types, List<IType> inferringTypes) {
        double degrees = 0.0;
        if (parameterType.isParameterizedType()) {
            parameterType = this.getGenericType(parameterType);
        }
        for (IType iType : types) {
            void var7_6;
            IType iType2;
            IType componentType;
            IType iType3 = componentType = iType.isArray() ? iType.getComponentType() : iType;
            if (componentType.isParameterizedType() && types.contains(iType2 = this.getGenericType(componentType)) || parameterType == var7_6) continue;
            if (parameterType instanceof IInvocableType && var7_6 instanceof IInvocableType) {
                degrees += this.scoreMethod((IInvocableType)parameterType, Arrays.asList(((IInvocableType)var7_6).getParameterTypes()), inferringTypes);
                if (!(parameterType instanceof IFunctionType) || !(var7_6 instanceof IFunctionType)) continue;
                degrees += this.addToScoreForTypes(inferringTypes, ((IFunctionType)parameterType).getReturnType(), ((IFunctionType)var7_6).getReturnType());
                continue;
            }
            if (!parameterType.isAssignableFrom((IType)var7_6)) continue;
            degrees += 1.0;
        }
        return degrees;
    }

    public <E extends IType> E getGenericType(E type) {
        if (type == null || TypeSystem.isDeleted(type)) {
            return null;
        }
        if (type.isArray()) {
            return (E)this.getGenericType(type.getComponentType()).getArrayType();
        }
        while (type.isParameterizedType()) {
            type = type.getGenericType();
        }
        return type;
    }

    public IInvocableType getCachedMethodScore(IInvocableType funcType, IType callsiteEnclosingType, IType rootType, List<IType> argTypes) {
        return (IInvocableType)this._methodScoreCache.get(new MethodScoreKey(argTypes, funcType, callsiteEnclosingType, rootType));
    }

    public MethodScoreKey putCachedMethodScore(MethodScore score) {
        score.setScore(0.0);
        List<IExpression> argExpressions = score.getArguments();
        ArrayList<IType> argTypes = new ArrayList<IType>(argExpressions.size());
        for (IExpression argExpression : argExpressions) {
            argTypes.add(argExpression.getType());
        }
        MethodScoreKey key = new MethodScoreKey(argTypes, score);
        this._methodScoreCache.put(key, score.getRawFunctionType());
        return key;
    }

    public void removeCachedMethodScore(MethodScoreKey key) {
        this._methodScoreCache.remove(key);
    }

    public static class MethodScoreKey {
        private String _methodName;
        private IType _declaringType;
        private IType _rootType;
        private IRelativeTypeInfo.Accessibility _acc;
        private List<IType> _argTypes;

        private MethodScoreKey(List<IType> argTypes, IInvocableType funcType, IType callsiteEnclosingType, IType rootType) {
            this._argTypes = argTypes;
            this._rootType = rootType;
            if (rootType != null && callsiteEnclosingType != null) {
                if (rootType instanceof IMetaType) {
                    rootType = ((IMetaType)rootType).getType();
                }
                this._acc = FeatureManager.getAccessibilityForClass(rootType, callsiteEnclosingType);
            } else {
                this._acc = IRelativeTypeInfo.Accessibility.NONE;
            }
            if (funcType instanceof IConstructorType) {
                this._methodName = "construct";
                this._declaringType = ((IConstructorType)funcType).getDeclaringType();
            } else {
                this._methodName = funcType.getDisplayName();
                this._declaringType = funcType.getEnclosingType();
            }
        }

        public MethodScoreKey(List<IType> argTypes, MethodScore score) {
            this._argTypes = argTypes;
            this._rootType = score.getReceiverType();
            this._acc = score.getAccessibility();
            IInvocableType funcType = score.getRawFunctionType();
            if (funcType instanceof IConstructorType) {
                this._methodName = "construct";
                this._declaringType = ((IConstructorType)funcType).getDeclaringType();
            } else {
                this._methodName = funcType.getDisplayName();
                this._declaringType = funcType.getEnclosingType();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodScoreKey that = (MethodScoreKey)o;
            if (!this._argTypes.equals(that._argTypes)) {
                return false;
            }
            if (this._declaringType != null ? !this._declaringType.equals(that._declaringType) : that._declaringType != null) {
                return false;
            }
            if (this._rootType != null ? !this._rootType.equals(that._rootType) : that._rootType != null) {
                return false;
            }
            if (this._acc != null ? !this._acc.equals((Object)that._acc) : that._acc != null) {
                return false;
            }
            return this._methodName.equals(that._methodName);
        }

        public int hashCode() {
            int result = this._methodName.hashCode();
            result = 31 * result + (this._declaringType != null ? this._declaringType.hashCode() : 0);
            result = 31 * result + (this._rootType != null ? this._rootType.hashCode() : 0);
            result = 31 * result + (this._acc != null ? this._acc.hashCode() : 0);
            result = 31 * result + this._argTypes.hashCode();
            return result;
        }
    }

    private static class MethodScoreCache
    extends HashMap<MethodScoreKey, IInvocableType>
    implements ITypeLoaderListener {
        MethodScoreCache() {
            TypeSystem.addTypeLoaderListenerAsWeakRef(this);
        }

        @Override
        public void refreshed() {
            this.clear();
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
            this.clear();
        }
    }
}

