/*
 * Decompiled with CFR 0.152.
 */
package gw.util.cache;

import gw.internal.gosu.parser.StringCache;
import gw.lang.parser.TypeSystemAwareCache;
import gw.util.DynamicArray;
import gw.util.Predicate;
import gw.util.cache.FqnCacheNode;
import gw.util.cache.IFqnCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class FqnCache<T>
implements IFqnCache<T> {
    private static final TypeSystemAwareCache<String, String[]> PARTS_CACHE = TypeSystemAwareCache.make("Fqn Parts Cache", 10000, FqnCache::split);
    private FqnCacheNode<T> _root = new FqnCacheNode("root", null);

    public FqnCacheNode<T> getRoot() {
        return this._root;
    }

    @Override
    public FqnCacheNode<T> getNode(String fqn) {
        String part;
        FqnCacheNode<T> n = this._root;
        String[] stringArray = FqnCache.getParts(fqn);
        int n2 = stringArray.length;
        for (int i = 0; i < n2 && (n = n.getChild(part = stringArray[i])) != null; ++i) {
        }
        return n;
    }

    @Override
    public final T get(String fqn) {
        FqnCacheNode<T> n = this.getNode(fqn);
        return n == null ? null : (T)n.getUserData();
    }

    @Override
    public final boolean contains(String fqn) {
        return this.getNode(fqn) != null;
    }

    @Override
    public final void add(String fqn) {
        this.add(fqn, null);
    }

    @Override
    public void add(String fqn, T userData) {
        FqnCacheNode<T> n = this._root;
        for (String part : FqnCache.getParts(fqn)) {
            n = n.getOrCreateChild(part);
        }
        n.setUserData(userData);
    }

    @Override
    public final void remove(String[] fqns) {
        for (String fqn : fqns) {
            this.remove(fqn);
        }
    }

    @Override
    public boolean remove(String fqn) {
        FqnCacheNode<T> n = this._root;
        for (String part : FqnCache.getParts(fqn)) {
            if ((n = n.getChild(part)) != null) continue;
            return false;
        }
        n.delete();
        return true;
    }

    @Override
    public final void clear() {
        this._root.clear();
    }

    @Override
    public Set<String> getFqns() {
        HashSet<String> names = new HashSet<String>();
        this._root.collectNames(names, "");
        return names;
    }

    @Override
    public void visitDepthFirst(Predicate<T> visitor) {
        ArrayList<FqnCacheNode<T>> copy = new ArrayList<FqnCacheNode<T>>(this._root.getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            if (fqnCacheNode.visitDepthFirst(visitor)) continue;
            return;
        }
    }

    @Override
    public void visitNodeDepthFirst(Predicate<FqnCacheNode> visitor) {
        ArrayList<FqnCacheNode<T>> copy = new ArrayList<FqnCacheNode<T>>(this._root.getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            if (fqnCacheNode.visitNodeDepthFirst(visitor)) continue;
            return;
        }
    }

    @Override
    public void visitBreadthFirst(Predicate<T> visitor) {
        ArrayList<FqnCacheNode<T>> copy = new ArrayList<FqnCacheNode<T>>(this._root.getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            fqnCacheNode.visitBreadthFirst(visitor);
        }
    }

    private static String[] split(String fqn) {
        String theRest = fqn;
        DynamicArray<String> parts = new DynamicArray<String>();
        while (theRest != null) {
            String part;
            int iParam = theRest.indexOf(60);
            int iDot = theRest.indexOf(46);
            int iArray = theRest.indexOf(91);
            if (iParam == 0) {
                if (iArray > 0) {
                    part = theRest.substring(0, iArray);
                    theRest = iArray < theRest.length() ? theRest.substring(iArray) : null;
                } else {
                    if (theRest.charAt(theRest.length() - 1) != '>') {
                        throw new RuntimeException("\"" + theRest + "\" does not end with '>'");
                    }
                    part = theRest;
                    theRest = null;
                }
            } else if (iArray == 0) {
                part = theRest.substring(0, 2);
                theRest = part.length() == theRest.length() ? null : theRest.substring(2);
            } else if (iParam > 0) {
                if (iDot > 0 && iDot < iParam) {
                    part = theRest.substring(0, iDot);
                    theRest = iDot + 1 < theRest.length() ? theRest.substring(iDot + 1) : null;
                } else {
                    part = theRest.substring(0, iParam);
                    theRest = iParam < theRest.length() ? theRest.substring(iParam) : null;
                }
            } else if (iDot > 0) {
                part = theRest.substring(0, iDot);
                theRest = iDot + 1 < theRest.length() ? theRest.substring(iDot + 1) : null;
            } else {
                part = theRest;
                theRest = null;
            }
            parts.add(FqnCache.isCacheableString(part) ? StringCache.get(part) : part);
        }
        return parts.toArray(new String[parts.size()]);
    }

    private static boolean isCacheableString(String part) {
        return !part.startsWith("__Fragment__");
    }

    public static String[] getParts(String fqn) {
        return (String[])PARTS_CACHE.get(fqn);
    }
}

