/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.util.DynamicArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class MethodList
extends DynamicArray<IMethodInfo> {
    public static final MethodList EMPTY = new MethodList();
    private HashMap<String, DynamicArray<IMethodInfo>> _map = new HashMap();

    public MethodList() {
    }

    public MethodList(List<IMethodInfo> methods) {
        this.addAll((Collection<? extends IMethodInfo>)methods);
    }

    public MethodList(int size) {
        super(size);
    }

    protected MethodList(MethodList source) {
        super(source);
        this._map = new HashMap<String, DynamicArray<IMethodInfo>>(source._map);
    }

    public MethodList copy() {
        return new MethodList(this);
    }

    public MethodList filterMethods(IRelativeTypeInfo.Accessibility accessibility) {
        MethodList ret = new MethodList();
        for (IMethodInfo method : this) {
            if (!FeatureManager.isFeatureAccessible(method, accessibility)) continue;
            ret.add(method);
        }
        ret.trimToSize();
        return ret;
    }

    @Override
    public boolean add(IMethodInfo method) {
        this.addToMap(method);
        return super.add(method);
    }

    @Override
    public boolean addAll(Collection<? extends IMethodInfo> c) {
        for (IMethodInfo iMethodInfo : c) {
            this.addToMap(iMethodInfo);
        }
        return super.addAll(c);
    }

    private void addToMap(IMethodInfo method) {
        String displayName = method.getDisplayName();
        DynamicArray<IMethodInfo> methods = this._map.get(displayName);
        if (methods == null) {
            methods = new DynamicArray(1);
            this._map.put(displayName, methods);
        }
        methods.add(method);
    }

    @Override
    public IMethodInfo remove(int index) {
        IMethodInfo oldMethod = (IMethodInfo)this.get(index);
        String displayName = oldMethod.getDisplayName();
        DynamicArray<IMethodInfo> methods = this._map.get(displayName);
        int i = methods.indexOf(oldMethod);
        methods.remove(i);
        return (IMethodInfo)super.remove(index);
    }

    @Override
    public IMethodInfo set(int index, IMethodInfo method) {
        IMethodInfo oldMethod = (IMethodInfo)this.get(index);
        String displayName = method.getDisplayName();
        DynamicArray<IMethodInfo> methods = this._map.get(displayName);
        int i = methods.indexOf(oldMethod);
        methods.set(i, method);
        return super.set(index, method);
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != o) continue;
            return i;
        }
        return -1;
    }

    public DynamicArray<? extends IMethodInfo> getMethods(String name) {
        DynamicArray methodInfoList = this._map.get(name);
        return methodInfoList != null ? methodInfoList : DynamicArray.EMPTY;
    }

    public static MethodList singleton(IMethodInfo theOneMethod) {
        MethodList infos = new MethodList(1);
        infos.add(theOneMethod);
        return infos;
    }

    @Override
    public void add(int index, IMethodInfo method) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public boolean addAll(int index, Collection<? extends IMethodInfo> c) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("Not supported");
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void clear() {
        super.clear();
        this._map.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not supported");
    }

    public IMethodInfo findAssignableMethod(IMethodInfo miTo, boolean bStatic, TypeVarToTypeMap inferenceMap) {
        String mname = miTo.getDisplayName();
        DynamicArray<? extends IMethodInfo> methods = this.getMethods(mname);
        if (methods.isEmpty()) {
            return null;
        }
        IType ownersType = miTo.getOwnersType();
        IMethodInfo foundMethod = null;
        TypeVarToTypeMap foundInferenceMap = null;
        IParameterInfo[] toParams = miTo.getParameters();
        int iTopScore = 0;
        block0: for (IMethodInfo iMethodInfo : methods) {
            IParameterInfo[] fromParams;
            IType fromReturnType;
            TypeVarToTypeMap copyInferenceMap;
            IType toReturnType;
            if (iMethodInfo.isStatic() != bStatic || !iMethodInfo.getDisplayName().equals(mname) || !(toReturnType = MethodList.maybeInferReturnType(copyInferenceMap = new TypeVarToTypeMap(inferenceMap), ownersType, iMethodInfo.getReturnType(), miTo.getReturnType())).equals(fromReturnType = TypeSystem.replaceTypeVariableTypeParametersWithBoundingTypes(iMethodInfo.getReturnType(), iMethodInfo.getOwnersType())) && !toReturnType.isAssignableFrom(fromReturnType) && !StandardCoercionManager.isStructurallyAssignable(toReturnType, fromReturnType) && !StandardCoercionManager.arePrimitiveTypesAssignable(toReturnType, fromReturnType) && !TypeSystem.isBoxedTypeFor(toReturnType, fromReturnType) && !TypeSystem.isBoxedTypeFor(fromReturnType, toReturnType) || (fromParams = iMethodInfo.getParameters()).length != toParams.length) continue;
            if (fromParams.length == 0) {
                foundMethod = iMethodInfo;
                foundInferenceMap = copyInferenceMap;
            }
            int iScore = 0;
            for (int ip = 0; ip < fromParams.length; ++ip) {
                IParameterInfo fromParam = fromParams[ip];
                IParameterInfo toParam = toParams[ip];
                IType toParamType = MethodList.maybeInferParamType(copyInferenceMap, ownersType, fromParam.getFeatureType(), toParam.getFeatureType());
                IType fromParamType = TypeSystem.replaceTypeVariableTypeParametersWithBoundingTypes(fromParam.getFeatureType(), iMethodInfo.getOwnersType());
                if (fromParamType.equals(toParamType)) {
                    iScore += 2;
                    continue;
                }
                if (!fromParamType.isAssignableFrom(toParamType) && !StandardCoercionManager.isStructurallyAssignable(fromParamType, toParamType) && !StandardCoercionManager.arePrimitiveTypesAssignable(fromParamType, toParamType) && !TypeSystem.isBoxedTypeFor(toParamType, fromParamType) && !TypeSystem.isBoxedTypeFor(fromParamType, toParamType)) continue block0;
                ++iScore;
            }
            if (iTopScore >= iScore) continue;
            foundMethod = iMethodInfo;
            foundInferenceMap = copyInferenceMap;
            iTopScore = iScore;
        }
        if (foundMethod != null) {
            inferenceMap.putAllAndInferred(foundInferenceMap);
        }
        return foundMethod;
    }

    public Collection<DynamicArray<IMethodInfo>> getMethodBuckets() {
        return this._map.values();
    }

    public static IType maybeInferParamType(TypeVarToTypeMap inferenceMap, IType ownersType, IType fromParamType, IType toParamType) {
        int iCount = inferenceMap.size();
        IType toCompType = toParamType;
        while (toCompType.isArray()) {
            toCompType = toCompType.getComponentType();
        }
        if (toCompType instanceof ITypeVariableType || toCompType.isParameterizedType()) {
            TypeSystem.inferTypeVariableTypesFromGenParamTypeAndConcreteType(toParamType, fromParamType, inferenceMap, true);
            if (inferenceMap.size() > iCount) {
                IType actualType = TypeSystem.getActualType(toParamType, inferenceMap, false);
                toParamType = actualType == null ? toParamType : actualType;
            }
        }
        return TypeSystem.replaceTypeVariableTypeParametersWithBoundingTypes(toParamType, ownersType);
    }

    public static IType maybeInferReturnType(TypeVarToTypeMap inferenceMap, IType ownersType, IType fromReturnType, IType toReturnType) {
        int iCount = inferenceMap.size();
        IType toCompType = toReturnType;
        while (toCompType.isArray()) {
            toCompType = toCompType.getComponentType();
        }
        boolean bTypeVar = toCompType instanceof ITypeVariableType;
        if (bTypeVar || toCompType.isParameterizedType()) {
            TypeSystem.inferTypeVariableTypesFromGenParamTypeAndConcreteType(toReturnType, fromReturnType, inferenceMap, false);
            if (bTypeVar && inferenceMap.get((ITypeVariableType)toCompType) != null || inferenceMap.size() > iCount) {
                IType actualType = TypeSystem.getActualType(toReturnType, inferenceMap, false);
                toReturnType = actualType == null ? toReturnType : actualType;
            }
        }
        return TypeSystem.replaceTypeVariableTypeParametersWithBoundingTypes(toReturnType, ownersType);
    }
}

