/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.features;

import gw.lang.PublishedName;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.features.BlockWrapper;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.IMethodReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MethodReference<R, T>
extends FeatureReference<R, T>
implements IMethodReference<R, T> {
    private IMethodInfo _mi;
    private IType _rootType;
    private Object[] _boundValues;

    public MethodReference(IType rootType, String funcName, IType[] params, Object[] boundValues) {
        this._rootType = rootType;
        this._mi = MethodReference.getMethodInfo(rootType, funcName, params);
        this._boundValues = boundValues;
    }

    static IMethodInfo getMethodInfo(IType rootType, String funcName, IType[] params) {
        ITypeInfo typeInfo = rootType.getTypeInfo();
        if (typeInfo instanceof IRelativeTypeInfo) {
            return ((IRelativeTypeInfo)typeInfo).getMethod(rootType, funcName, params);
        }
        return typeInfo.getMethod(funcName, params);
    }

    @Override
    public IMethodInfo getMethodInfo() {
        return this._mi;
    }

    @Override
    @PublishedName(value="invoke")
    public T getinvoke() {
        return this.toBlock();
    }

    @Override
    public T toBlock() {
        return (T)BlockWrapper.toBlock(this);
    }

    @Override
    public Object[] getBoundArgValues() {
        return this._boundValues;
    }

    @Override
    public Object evaluate(Object ... args) {
        return this.evaluate(Arrays.asList(args).iterator());
    }

    @Override
    protected Object evaluate(Iterator args) {
        Object ctx = null;
        if (!this._mi.isStatic()) {
            ctx = args.next();
        }
        if (this._boundValues != null) {
            args = Arrays.asList(this._boundValues).iterator();
        }
        Object[] argArray = new Object[this._mi.getParameters().length];
        for (int i = 0; i < argArray.length; ++i) {
            argArray[i] = args.next();
        }
        return this._mi.getCallHandler().handleCall(ctx, argArray);
    }

    @Override
    public List<IType> getFullArgTypes() {
        ArrayList<IType> argTypes = new ArrayList<IType>();
        if (!this._mi.isStatic()) {
            argTypes.add(this._mi.getOwnersType());
        }
        if (this._boundValues == null) {
            for (IParameterInfo iParameterInfo : this._mi.getParameters()) {
                argTypes.add(iParameterInfo.getFeatureType());
            }
        }
        return argTypes;
    }

    @Override
    public IFeatureInfo getFeatureInfo() {
        return this.getMethodInfo();
    }

    @Override
    public IType getRootType() {
        return this._rootType;
    }

    public Object[] getBoundValues() {
        return this._boundValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodReference that = (MethodReference)o;
        if (!Arrays.equals(this._boundValues, that._boundValues)) {
            return false;
        }
        if (this._mi != null ? !this._mi.equals(that._mi) : that._mi != null) {
            return false;
        }
        return !(this._rootType != null ? !this._rootType.equals(that._rootType) : that._rootType != null);
    }

    public int hashCode() {
        int result = this._mi != null ? this._mi.hashCode() : 0;
        result = 31 * result + (this._rootType != null ? this._rootType.hashCode() : 0);
        result = 31 * result + (this._boundValues != null ? Arrays.hashCode(this._boundValues) : 0);
        return result;
    }
}

