/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import java.util.Collection;
import java.util.Iterator;

public class IdentitySet<T>
implements Iterable<T> {
    private int _index;
    private T[] _set;

    public IdentitySet(int size) {
        this._set = new Object[size];
    }

    public boolean isEmpty() {
        return this._index == 0;
    }

    public int size() {
        return this._index;
    }

    public boolean contains(T o) {
        for (int i = 0; i < this._index; ++i) {
            if (this._set[i] != o) continue;
            return true;
        }
        return false;
    }

    public void add(T o) {
        if (!this.contains(o)) {
            if (this._index == this._set.length) {
                T[] oldSet = this._set;
                this._set = new Object[this._set.length * 2];
                System.arraycopy(oldSet, 0, this._set, 0, this.size());
            }
            this._set[this._index] = o;
            ++this._index;
        }
    }

    public void remove(T o) {
        throw new RuntimeException("Not supported");
    }

    public void addAll(Collection<? extends T> c) {
        for (T o : c) {
            this.add(o);
        }
    }

    public void clear() {
        for (int i = 0; i < this._index; ++i) {
            this._set[i] = null;
        }
        this._index = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i <= IdentitySet.this._index - 1;
            }

            @Override
            public T next() {
                Object o = IdentitySet.this._set[this.i];
                ++this.i;
                return o;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not supported");
            }
        };
    }

    public String toString() {
        return this.size() + " items";
    }

    public T[] toArray(T[] array) {
        Iterator<T> iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            array[i] = iterator.next();
            ++i;
        }
        return array;
    }
}

