/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.statement;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.statement.IRBreakStatement;
import gw.lang.ir.statement.IRContinueStatement;
import gw.lang.ir.statement.IRNoOpStatement;
import gw.lang.ir.statement.IRTerminalStatement;

@UnstableAPI
public class IRIfStatement
extends IRStatement {
    private IRExpression _expression;
    private IRStatement _ifStatement;
    private IRStatement _elseStatement;

    public IRIfStatement(IRExpression expression, IRStatement ifStatement, IRStatement elseStatement) {
        if (ifStatement == null) {
            ifStatement = new IRNoOpStatement();
        }
        this._expression = expression;
        this._ifStatement = ifStatement;
        this._elseStatement = elseStatement;
        expression.setParent(this);
        ifStatement.setParent(this);
        if (elseStatement != null) {
            elseStatement.setParent(this);
        }
    }

    public IRExpression getExpression() {
        return this._expression;
    }

    public IRStatement getIfStatement() {
        return this._ifStatement;
    }

    public IRStatement getElseStatement() {
        return this._elseStatement;
    }

    public void setElseStatement(IRStatement elseStatement) {
        this._elseStatement = elseStatement;
        this.setParentToThis(elseStatement);
    }

    @Override
    public IRTerminalStatement getLeastSignificantTerminalStatement() {
        IRTerminalStatement elseStmtTerminal;
        IRTerminalStatement ifStmtTerminal = this._ifStatement.getLeastSignificantTerminalStatement();
        if (ifStmtTerminal != null && this._elseStatement != null && (elseStmtTerminal = this._elseStatement.getLeastSignificantTerminalStatement()) != null) {
            if (ifStmtTerminal instanceof IRBreakStatement || ifStmtTerminal instanceof IRContinueStatement) {
                return ifStmtTerminal;
            }
            if (elseStmtTerminal instanceof IRBreakStatement || elseStmtTerminal instanceof IRContinueStatement) {
                return elseStmtTerminal;
            }
            return ifStmtTerminal;
        }
        return null;
    }
}

