/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.coercers;

import gw.config.CommonServices;
import gw.lang.function.IBlock;
import gw.lang.parser.coercers.BaseCoercer;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import gw.util.GosuClassUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;

public class BlockCoercer
extends BaseCoercer {
    private static final BlockCoercer INSTANCE = new BlockCoercer();

    private BlockCoercer() {
    }

    @Override
    public Object coerceValue(IType typeToCoerceTo, Object value) {
        final IBlock blk = (IBlock)value;
        Class<?> aClass = blk.getClass();
        final Method finalInvoke = this.getInvokeMethod(aClass);
        final IFunctionType funType = (IFunctionType)typeToCoerceTo;
        Set<Class> classes = GosuClassUtil.getAllInterfaces(aClass);
        Class[] interfaces = classes.toArray(new Class[classes.size()]);
        return Proxy.newProxyInstance(blk.getClass().getClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("invoke".equals(method.getName())) {
                    Object val = finalInvoke.invoke((Object)blk, args);
                    return CommonServices.getCoercionManager().convertValue(val, funType.getReturnType());
                }
                if ("invokeWithArgs".equals(method.getName())) {
                    Object val = blk.invokeWithArgs((Object[])args[0]);
                    return CommonServices.getCoercionManager().convertValue(val, funType.getReturnType());
                }
                return method.invoke((Object)blk, args);
            }
        });
    }

    private Method getInvokeMethod(Class<? extends IBlock> aClass) {
        Method invokeMethod = null;
        for (Method method : aClass.getMethods()) {
            if (!method.getName().equals("invoke")) continue;
            invokeMethod = method;
        }
        if (invokeMethod == null) {
            throw new IllegalStateException("Unable to find an invoke method on class " + aClass.getName());
        }
        return invokeMethod;
    }

    @Override
    public boolean isExplicitCoercion() {
        return false;
    }

    @Override
    public boolean handlesNull() {
        return false;
    }

    @Override
    public int getPriority(IType to, IType from) {
        return 2;
    }

    public static BlockCoercer instance() {
        return INSTANCE;
    }
}

