/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc.simple;

import gw.lang.gosuc.simple.ICompilerDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;

public class SoutCompilerDriver
implements ICompilerDriver {
    private final boolean _echo;
    private final boolean _includeWarnings;
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();

    public SoutCompilerDriver() {
        this(false, true);
    }

    public SoutCompilerDriver(boolean echo, boolean warnings) {
        this._echo = echo;
        this._includeWarnings = warnings;
    }

    @Override
    public void sendCompileIssue(File file, int category, long offset, long line, long column, String message) {
        this.sendCompileIssue((Object)file, category, offset, line, column, message);
    }

    @Override
    public void sendCompileIssue(Object file, int category, long offset, long line, long column, String message) {
        if (category == 1) {
            String warning = String.format("%s:[%s,%s] warning: %s", file.toString(), line, column, message);
            this.warnings.add(warning);
            if (this._echo && this._includeWarnings) {
                System.out.println(warning);
            }
        } else if (category == 0) {
            String error = String.format("%s:[%s,%s] error: %s", file.toString(), line, column, message);
            this.errors.add(error);
            if (this._echo) {
                System.out.println(error);
            }
        }
    }

    @Override
    public void sendCompileIssue(Diagnostic d) {
        this.sendCompileIssue(d.getSource(), d.getKind() == Diagnostic.Kind.ERROR ? 0 : 1, d.getStartPosition(), d.getLineNumber(), d.getColumnNumber(), d.getMessage(Locale.getDefault()));
    }

    @Override
    public void registerOutput(File sourceFile, File outputFile) {
        this.registerOutput((Object)sourceFile, outputFile);
    }

    @Override
    public void registerOutput(Object sourceFile, File outputFile) {
    }

    public boolean isIncludeWarnings() {
        return this._includeWarnings;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

