/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.features;

import gw.lang.PublishedName;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.features.BlockWrapper;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.IMethodReference;
import gw.lang.reflect.features.MethodReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class BoundMethodReference<R, T>
extends FeatureReference<R, T>
implements IMethodReference<R, T> {
    private IMethodInfo _mi;
    private IType _rootType;
    private Object _ctx;
    private Object[] _boundValues;
    private boolean _voidReturn;

    public BoundMethodReference(IType rootType, Object ctx, String funcName, IType[] params, Object[] boundValues) {
        this._rootType = rootType;
        this._ctx = ctx;
        this._mi = MethodReference.getMethodInfo(rootType, funcName, params);
        this._boundValues = boundValues;
    }

    private BoundMethodReference() {
    }

    @Override
    public BoundMethodReference copyWithVoidReturn() {
        BoundMethodReference<R, T> voidReturnCopy = new BoundMethodReference<R, T>();
        voidReturnCopy._mi = this._mi;
        voidReturnCopy._rootType = this._rootType;
        voidReturnCopy._ctx = this._ctx;
        voidReturnCopy._boundValues = this._boundValues;
        voidReturnCopy._voidReturn = true;
        return voidReturnCopy;
    }

    @Override
    protected boolean hasReturn() {
        return !this._voidReturn && super.hasReturn();
    }

    @Override
    public IMethodInfo getMethodInfo() {
        return this._mi;
    }

    @Override
    @PublishedName(value="invoke")
    public T getinvoke() {
        return this.toBlock();
    }

    @Override
    public Object evaluate(Object ... args) {
        return this.evaluate(Arrays.asList(args).iterator());
    }

    @Override
    public Object evaluate(Iterator args) {
        if (this._boundValues != null) {
            args = Arrays.asList(this._boundValues).iterator();
        }
        Object[] argArray = new Object[this._mi.getParameters().length];
        for (int i = 0; i < argArray.length; ++i) {
            argArray[i] = args.next();
        }
        return this._mi.getCallHandler().handleCall(this._ctx, argArray);
    }

    @Override
    public IType getRootType() {
        return this._rootType;
    }

    @Override
    public T toBlock() {
        return (T)BlockWrapper.toBlock(this);
    }

    @Override
    public Object[] getBoundArgValues() {
        return this._boundValues;
    }

    @Override
    public IFeatureInfo getFeatureInfo() {
        return this.getMethodInfo();
    }

    @Override
    public List<IType> getFullArgTypes() {
        ArrayList<IType> lst = new ArrayList<IType>();
        if (this._boundValues == null) {
            for (IParameterInfo iParameterInfo : this._mi.getParameters()) {
                lst.add(iParameterInfo.getFeatureType());
            }
        }
        return lst;
    }

    public Object getCtx() {
        return this._ctx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundMethodReference that = (BoundMethodReference)o;
        if (!Arrays.equals(this._boundValues, that._boundValues)) {
            return false;
        }
        if (this._ctx != null ? !this._ctx.equals(that._ctx) : that._ctx != null) {
            return false;
        }
        if (this._mi != null ? !this._mi.equals(that._mi) : that._mi != null) {
            return false;
        }
        return !(this._rootType != null ? !this._rootType.equals(that._rootType) : that._rootType != null);
    }

    public int hashCode() {
        int result = this._mi != null ? this._mi.hashCode() : 0;
        result = 31 * result + (this._rootType != null ? this._rootType.hashCode() : 0);
        result = 31 * result + (this._ctx != null ? this._ctx.hashCode() : 0);
        result = 31 * result + (this._boundValues != null ? Arrays.hashCode(this._boundValues) : 0);
        return result;
    }
}

