/*
 * Decompiled with CFR 0.152.
 */
package gw.config;

import gw.config.DefaultCommonsServiceKernelInit;
import gw.config.TypeLoaderSpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Registry {
    public static final String TAG_ALLOW_DEPRECATED_REFERENCES = "allow-deprecated-references";
    public static final String TAG_ALLOW_ENTITY_QUERIES = "allow-entity-queries";
    private static final String COMMON_SERVICE_INIT = "common-service-init";
    private static final String TAG_SERIALIZATION = "serialization";
    private static final String TAG_TYPELOADERS = "typeloaders";
    private static final String TAG_TYPELOADER = "typeloader";
    private static final String TAG_CLASSPATH = "classpath";
    public static final String TAG_CLASS = "class";
    public static final String TAG_SRC = "src";
    public static final String TAG_ENTRY = "entry";
    private static Registry g_instance;
    private static List g_listeners;
    private boolean _bAllowDeprecatedReferences;
    private boolean _bAllowEntityQueires;
    private List<TypeLoaderSpec> _additionalTypeLoaderSpecs = Collections.emptyList();
    private List<String> _classpathEntries = Collections.emptyList();
    private String _commonServiceInit;
    private URL _registerUrl;

    public Registry(String kernelInitClass) {
        this._commonServiceInit = kernelInitClass;
    }

    public static void initDefaults() {
        try {
            Registry.setLocation(Registry.class.getResource("/gw/config/default.xml"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void setLocation(String kernelInitClass) {
        g_instance = new Registry(kernelInitClass);
    }

    public static void setLocation(URL registryURL) {
        Registry.setLocation(registryURL, DefaultCommonsServiceKernelInit.class.getName());
    }

    public static void setLocation(URL registryURL, String strCommonServicesInitDefault) {
        g_instance = new Registry(registryURL, strCommonServicesInitDefault);
        Registry.fireLocationChanged();
    }

    public static synchronized void addLocationListener(ChangeListener l) {
        g_listeners.add(l);
    }

    public static synchronized void removeLocationListener(ChangeListener l) {
        g_listeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLocationChanged() {
        if (g_listeners.isEmpty()) {
            return;
        }
        ChangeEvent e = new ChangeEvent(g_instance);
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            for (int i = 0; i < g_listeners.size(); ++i) {
                ((ChangeListener)g_listeners.get(i)).stateChanged(e);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Registry(URL registrURL, String strCommonServicesInitDefault) {
        try {
            Node classpathEntries;
            Node typeLoaders;
            String allowEntityQueries;
            String allowDeprecatedRefs;
            this._registerUrl = registrURL;
            Document doc = this.getDocument(registrURL);
            Node commonService = this.getTag(doc, COMMON_SERVICE_INIT);
            String kernelInit = null;
            if (commonService != null) {
                kernelInit = commonService.getAttributes().item(0).getNodeValue();
            }
            String string = kernelInit = kernelInit == null || kernelInit.isEmpty() ? strCommonServicesInitDefault : kernelInit;
            if (kernelInit != null) {
                this.setCommonServiceInit(kernelInit);
            }
            String string2 = allowDeprecatedRefs = this.getTag(doc, TAG_ALLOW_DEPRECATED_REFERENCES) == null ? null : this.getTag(doc, TAG_ALLOW_DEPRECATED_REFERENCES).getTextContent();
            if (allowDeprecatedRefs != null) {
                this.setAllowDeprecatedReferences(Boolean.valueOf(allowDeprecatedRefs));
            }
            String string3 = allowEntityQueries = this.getTag(doc, TAG_ALLOW_ENTITY_QUERIES) == null ? null : this.getTag(doc, TAG_ALLOW_ENTITY_QUERIES).getTextContent();
            if (allowEntityQueries != null) {
                this.setAllowEntityQueires(Boolean.valueOf(allowEntityQueries));
            }
            if ((typeLoaders = this.getTag(doc, TAG_TYPELOADERS)) != null) {
                ArrayList<TypeLoaderSpec> additionalTypeLoaders = new ArrayList<TypeLoaderSpec>();
                NodeList childNodes = typeLoaders.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node xmlNode = childNodes.item(i);
                    if (!xmlNode.getNodeName().equals(TAG_TYPELOADER)) continue;
                    additionalTypeLoaders.add(new TypeLoaderSpec(xmlNode, this._registerUrl));
                }
                this._additionalTypeLoaderSpecs = Collections.unmodifiableList(additionalTypeLoaders);
            }
            if ((classpathEntries = this.getTag(doc, TAG_CLASSPATH)) != null) {
                ArrayList<String> entries = new ArrayList<String>();
                NodeList childNodes = classpathEntries.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node xmlNode = childNodes.item(i);
                    if (!xmlNode.getNodeName().equals(TAG_ENTRY)) continue;
                    entries.add(xmlNode.getTextContent());
                }
                this._classpathEntries = Collections.unmodifiableList(entries);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Document getDocument(URL registrURL) throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = registrURL.openStream();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(inputStream));
        inputStream.close();
        return doc;
    }

    private Node getTag(Document doc, String tagName) {
        NodeList list = doc.getElementsByTagName(tagName);
        return list == null ? null : list.item(0);
    }

    public static Registry instance() {
        return g_instance;
    }

    public String getCommonServiceInit() {
        return this._commonServiceInit;
    }

    public void setCommonServiceInit(String commonServiceInit) {
        this._commonServiceInit = commonServiceInit;
    }

    public List<TypeLoaderSpec> getAdditionalTypeLoaders() {
        return this._additionalTypeLoaderSpecs;
    }

    public List<String> getClasspathEntries() {
        return this._classpathEntries;
    }

    public boolean isAllowDeprecatedReferences() {
        return this._bAllowDeprecatedReferences;
    }

    public void setAllowDeprecatedReferences(boolean bAllowDeprecatedReferences) {
        this._bAllowDeprecatedReferences = bAllowDeprecatedReferences;
    }

    public boolean isAllowEntityQueires() {
        return this._bAllowEntityQueires;
    }

    public void setAllowEntityQueires(boolean bAllowEntityQueires) {
        this._bAllowEntityQueires = bAllowEntityQueires;
    }

    public void updateClasspath(List<String> classpath) {
        if (new HashSet<String>(classpath).equals(new HashSet<String>(this.getClasspathEntries()))) {
            return;
        }
        try {
            Document doc = this.getDocument(this._registerUrl);
            Node classpathEntries = this.getTag(doc, TAG_CLASSPATH);
            if (classpathEntries == null) {
                Node ser = this.getTag(doc, TAG_SERIALIZATION);
                classpathEntries = doc.createElement(TAG_CLASSPATH);
                ser.appendChild(classpathEntries);
            } else {
                while (classpathEntries.hasChildNodes()) {
                    classpathEntries.removeChild(classpathEntries.getLastChild());
                }
            }
            ArrayList<String> classpathList = new ArrayList<String>();
            for (String strPath : classpath) {
                Element entry = doc.createElement(TAG_ENTRY);
                entry.setTextContent(strPath);
                classpathEntries.appendChild(entry);
                classpathList.add(strPath);
            }
            Registry.instance()._classpathEntries = classpathList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean canWrite(File file) {
        if (file.isFile() && !file.canWrite()) {
            return file.setWritable(true);
        }
        return true;
    }

    static {
        g_listeners = new ArrayList();
        Registry.initDefaults();
    }
}

