/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.parser.IExpression;
import gw.lang.reflect.ExceptionInfoBuilder;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorHandler;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IOptionalParamCapable;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ParameterInfoBuilder;
import gw.lang.reflect.TypeSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConstructorInfoBuilder {
    private ParameterInfoBuilder[] _parameters = new ParameterInfoBuilder[0];
    private IConstructorHandler _constructorHandler;
    private ExceptionInfoBuilder[] _exceptions = new ExceptionInfoBuilder[0];
    private String _deprecated;
    private String _description;
    private IRelativeTypeInfo.Accessibility _accessibility = IRelativeTypeInfo.Accessibility.PUBLIC;
    private Object _userData;

    public ConstructorInfoBuilder withAccessibility(IRelativeTypeInfo.Accessibility accessibility) {
        this._accessibility = accessibility;
        return this;
    }

    public ConstructorInfoBuilder withParameters(ParameterInfoBuilder ... parameters) {
        this._parameters = parameters == null ? new ParameterInfoBuilder[]{} : parameters;
        return this;
    }

    public ConstructorInfoBuilder withConstructorHandler(IConstructorHandler constructorHandler) {
        this._constructorHandler = constructorHandler;
        return this;
    }

    public ConstructorInfoBuilder withExceptions(ExceptionInfoBuilder ... exceptions) {
        this._exceptions = exceptions == null ? new ExceptionInfoBuilder[]{} : exceptions;
        return this;
    }

    public ConstructorInfoBuilder withDeprecated(String deprecated) {
        this._deprecated = deprecated;
        return this;
    }

    public ConstructorInfoBuilder withDescription(String description) {
        this._description = description;
        return this;
    }

    public ConstructorInfoBuilder withUserData(Object userData) {
        this._userData = userData;
        return this;
    }

    public ConstructorInfoBuilder like(Class clazz, Class ... params) {
        IType[] types = new IType[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = TypeSystem.get(params[i]);
        }
        return this.like(TypeSystem.get(clazz), types);
    }

    public ConstructorInfoBuilder like(IType type, IType ... params) {
        return this.like(type.getTypeInfo().getConstructor(params));
    }

    public ConstructorInfoBuilder like(IConstructorInfo constructor) {
        this.withConstructorHandler(constructor.getConstructor());
        this.withDeprecated(constructor.getDeprecatedReason());
        this.withDescription(constructor.getDescription());
        IParameterInfo[] delegateParams = constructor.getParameters();
        ParameterInfoBuilder[] params = new ParameterInfoBuilder[delegateParams.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = new ParameterInfoBuilder().like(delegateParams[i]);
        }
        this.withParameters(params);
        List<IExceptionInfo> delegateExceptions = constructor.getExceptions();
        ExceptionInfoBuilder[] exceptions = new ExceptionInfoBuilder[delegateExceptions.size()];
        int idx = 0;
        for (IExceptionInfo info : delegateExceptions) {
            exceptions[idx++] = new ExceptionInfoBuilder().like(info);
        }
        this.withExceptions(exceptions);
        return this;
    }

    public IConstructorInfo build(IFeatureInfo container) {
        return new BuiltConstructorInfo(this, container);
    }

    private static class BuiltConstructorInfo
    implements IConstructorInfo,
    IOptionalParamCapable,
    IBuilt {
        private final IFeatureInfo _container;
        private final IParameterInfo[] _parameters;
        private final IConstructorHandler _constructorHandler;
        private final List<IExceptionInfo> _exceptions;
        private final String _deprecated;
        private final String _description;
        private final IRelativeTypeInfo.Accessibility _accessibility;
        private final Object _userData;

        public BuiltConstructorInfo(ConstructorInfoBuilder builder, IFeatureInfo container) {
            assert (container != null);
            this._container = container;
            this._parameters = new IParameterInfo[builder._parameters.length];
            for (int i = 0; i < builder._parameters.length; ++i) {
                this._parameters[i] = builder._parameters[i].build(this._container);
            }
            this._constructorHandler = builder._constructorHandler;
            IExceptionInfo[] tmp = new IExceptionInfo[builder._exceptions.length];
            for (int i = 0; i < builder._exceptions.length; ++i) {
                tmp[i] = builder._exceptions[i].build(this._container);
            }
            this._exceptions = Collections.unmodifiableList(Arrays.asList(tmp));
            this._deprecated = builder._deprecated;
            this._description = builder._description;
            this._userData = builder._userData;
            this._accessibility = builder._accessibility;
        }

        @Override
        public IParameterInfo[] getParameters() {
            return this._parameters;
        }

        @Override
        public IType getType() {
            return this._container.getOwnersType();
        }

        @Override
        public IConstructorHandler getConstructor() {
            return this._constructorHandler;
        }

        @Override
        public List<IExceptionInfo> getExceptions() {
            return this._exceptions;
        }

        @Override
        public Object getUserData() {
            return this._userData;
        }

        @Override
        public boolean isDefault() {
            return false;
        }

        @Override
        public boolean isScriptable() {
            return true;
        }

        @Override
        public boolean isDeprecated() {
            return this._deprecated != null;
        }

        @Override
        public String getDeprecatedReason() {
            return this._deprecated;
        }

        @Override
        public boolean isDefaultImpl() {
            return false;
        }

        @Override
        public boolean isVisible(IScriptabilityModifier constraint) {
            return true;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public boolean isPrivate() {
            return this._accessibility.equals((Object)IRelativeTypeInfo.Accessibility.PRIVATE);
        }

        @Override
        public boolean isInternal() {
            return this._accessibility.equals((Object)IRelativeTypeInfo.Accessibility.INTERNAL);
        }

        @Override
        public boolean isProtected() {
            return this._accessibility.equals((Object)IRelativeTypeInfo.Accessibility.PROTECTED);
        }

        @Override
        public boolean isPublic() {
            return this._accessibility.equals((Object)IRelativeTypeInfo.Accessibility.PUBLIC);
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isReified() {
            return false;
        }

        @Override
        public List<IAnnotationInfo> getAnnotations() {
            return Collections.emptyList();
        }

        @Override
        public List<IAnnotationInfo> getDeclaredAnnotations() {
            return Collections.emptyList();
        }

        @Override
        public List<IAnnotationInfo> getAnnotationsOfType(IType type) {
            return Collections.emptyList();
        }

        @Override
        public IAnnotationInfo getAnnotation(IType type) {
            return null;
        }

        @Override
        public boolean hasDeclaredAnnotation(IType type) {
            return false;
        }

        @Override
        public boolean hasAnnotation(IType type) {
            return false;
        }

        @Override
        public IFeatureInfo getContainer() {
            return this._container;
        }

        @Override
        public IType getOwnersType() {
            return this._container.getOwnersType();
        }

        @Override
        public String getName() {
            return this.makeSignature();
        }

        private String makeSignature() {
            Object name = this.getDisplayName();
            name = (String)name + "(";
            IParameterInfo[] parameterInfos = this.getParameters();
            if (parameterInfos.length > 0) {
                name = (String)name + " ";
                for (int i = 0; i < parameterInfos.length; ++i) {
                    IParameterInfo iParameterInfo = this.getParameters()[i];
                    if (i != 0) {
                        name = (String)name + ", ";
                    }
                    name = (String)name + iParameterInfo.getFeatureType().getName();
                }
                name = (String)name + " ";
            }
            name = (String)name + ")";
            return name;
        }

        @Override
        public String getDisplayName() {
            return this.getOwnersType().getRelativeName();
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuiltConstructorInfo that = (BuiltConstructorInfo)o;
            return this._container.getOwnersType() == that.getOwnersType() && this.getName().equals(that.getName());
        }

        public int hashCode() {
            int result = this._container.getOwnersType().hashCode();
            result = 31 * result + this.getName().hashCode();
            return result;
        }

        @Override
        public IExpression[] getDefaultValueExpressions() {
            IExpression[] defValues = new IExpression[this._parameters.length];
            for (int i = 0; i < this._parameters.length; ++i) {
                defValues[i] = ((ParameterInfoBuilder.BuiltParameterInfo)this._parameters[i]).getDefaultValue();
            }
            return defValues;
        }

        @Override
        public String[] getParameterNames() {
            String[] names = new String[this._parameters.length];
            for (int i = 0; i < this._parameters.length; ++i) {
                names[i] = this._parameters[i].getName();
            }
            return names;
        }
    }

    public static interface IBuilt {
        public Object getUserData();
    }
}

