/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import gw.lang.reflect.ILocationInfo;
import gw.lang.reflect.LocationInfo;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaClassInfo;
import java.net.MalformedURLException;
import java.util.StringTokenizer;

public abstract class JavaSourceElement {
    private LocationInfo _location;

    public abstract Tree getTree();

    public abstract IJavaClassInfo getEnclosingClass();

    public IJavaClassInfo getDeclaringClass() {
        return this.getEnclosingClass();
    }

    public CompilationUnitTree getCompilationUnitTree() {
        if (this.getEnclosingClass() instanceof JavaSourceElement) {
            return ((JavaSourceElement)((Object)this.getEnclosingClass())).getCompilationUnitTree();
        }
        return null;
    }

    public SourcePositions getSourcePositions() {
        if (this.getEnclosingClass() instanceof JavaSourceElement) {
            return ((JavaSourceElement)((Object)this.getEnclosingClass())).getSourcePositions();
        }
        return null;
    }

    public int getStartPosition() {
        SourcePositions sp = this.getSourcePositions();
        if (sp != null) {
            return (int)sp.getStartPosition(this.getCompilationUnitTree(), this.getTree());
        }
        return -1;
    }

    public int getEndPosition() {
        SourcePositions sp = this.getSourcePositions();
        if (sp != null) {
            return (int)sp.getEndPosition(this.getCompilationUnitTree(), this.getTree());
        }
        return -1;
    }

    public ILocationInfo getLocationInfo() {
        if (this._location != null) {
            return this._location;
        }
        int startPos = this.getStartPosition();
        int endPos = this.getEndPosition();
        try {
            ISourceFileHandle sfh = this.getDeclaringClass().getSourceFileHandle();
            if (sfh != null) {
                this._location = new LocationInfo(startPos, endPos - startPos, -1, -1, sfh.getFile().toURI().toURL());
            }
            return this._location;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected IJavaClassInfo findInnerSourceType(IJavaClassInfo topLevelType, String fqnInner) {
        String innerSuffix = fqnInner.substring(topLevelType.getName().length() + 1);
        StringTokenizer tokenizer = new StringTokenizer(innerSuffix, ".");
        IJavaClassInfo innerType = topLevelType;
        block0: while (tokenizer.hasMoreTokens()) {
            String innerName = tokenizer.nextToken();
            for (IJavaClassInfo innerClass : innerType.getDeclaredClasses()) {
                if (!innerClass.getSimpleName().equals(innerName)) continue;
                innerType = innerClass;
                continue block0;
            }
            throw new IllegalStateException("Should have found inner type");
        }
        return innerType;
    }
}

