/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.json;

import gw.lang.reflect.json.DynamicType;
import gw.lang.reflect.json.IJsonParentType;
import gw.lang.reflect.json.IJsonParser;
import gw.lang.reflect.json.IJsonType;
import gw.lang.reflect.json.JsonListType;
import gw.lang.reflect.json.JsonSimpleType;
import gw.lang.reflect.json.JsonStructureType;
import gw.util.concurrent.LocklessLazyVar;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptException;

public class Json {
    private static String _parser = System.getProperty("gosu.json.parser");
    private static final LocklessLazyVar<IJsonParser> PARSER = new LocklessLazyVar<IJsonParser>(){

        @Override
        protected IJsonParser init() {
            String fqn = Json.getParserName();
            return fqn == null ? IJsonParser.getDefaultParser() : this.makeParser(fqn);
        }

        private IJsonParser makeParser(String fqn) {
            try {
                return (IJsonParser)Class.forName(fqn).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static String getParserName() {
        return _parser;
    }

    public static void setParserName(String fqn) {
        _parser = fqn;
        PARSER.clear();
    }

    public static Bindings fromJson(String json) {
        try {
            return PARSER.get().parseJson(json);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeStructureTypes(String nameForStructure, Bindings bindings, boolean mutable) {
        JsonStructureType type = (JsonStructureType)Json.transformJsonObject(nameForStructure, null, bindings);
        StringBuilder sb = new StringBuilder();
        type.render(sb, 0, mutable);
        return sb.toString();
    }

    private static IJsonType transformJsonObject(String name, IJsonParentType parent, Object jsonObj) {
        IJsonType type = null;
        if (parent != null) {
            type = parent.findChild(name);
        }
        if (jsonObj == null) {
            return DynamicType.instance();
        }
        if (jsonObj instanceof Bindings) {
            if (type == null) {
                type = new JsonStructureType(parent, name);
            }
            for (Object k : ((Bindings)jsonObj).keySet()) {
                Object value;
                String key = (String)k;
                IJsonType memberType = Json.transformJsonObject(key, type, value = ((Bindings)jsonObj).get(key));
                if (memberType == null) continue;
                ((JsonStructureType)type).addMember(key, memberType);
            }
            if (parent != null) {
                parent.addChild(name, (IJsonParentType)type);
            }
        } else if (jsonObj instanceof List) {
            if (type == null) {
                type = new JsonListType(parent);
            }
            IJsonType compType = ((JsonListType)type).getComponentType();
            if (!((List)jsonObj).isEmpty()) {
                for (Object elem : (List)jsonObj) {
                    IJsonType csr = Json.transformJsonObject(name, type, elem);
                    if (compType != null && csr != compType && compType != DynamicType.instance()) {
                        csr = Json.mergeTypes(compType, csr);
                    }
                    compType = csr;
                }
            } else if (compType == null) {
                System.out.println("\nWarning: there are no sample elements in list: " + name + "\nThe component type for this list will be Dynamic.\n");
                compType = DynamicType.instance();
            }
            ((JsonListType)type).setComponentType(compType);
            if (parent != null) {
                parent.addChild(name, (IJsonParentType)type);
            }
        } else {
            type = JsonSimpleType.get(jsonObj);
        }
        return type;
    }

    public static IJsonType mergeTypes(IJsonType type1, IJsonType type2) {
        if (type1 == null && type2 != null) {
            return type2;
        }
        if (type2 == null && type1 != null) {
            return type1;
        }
        if (type1.equals(type2)) {
            return type1;
        }
        if (type1 == DynamicType.instance()) {
            return type2;
        }
        if (type2 == DynamicType.instance()) {
            return type1;
        }
        IJsonType mergedType = null;
        if (type1 instanceof JsonSimpleType && type2 instanceof JsonSimpleType) {
            mergedType = ((JsonSimpleType)type1).merge((JsonSimpleType)type2);
        }
        if (type1 instanceof JsonStructureType && type2 instanceof JsonStructureType) {
            mergedType = ((JsonStructureType)type1).merge((JsonStructureType)type2);
        }
        if (type1 instanceof JsonListType && type2 instanceof JsonListType) {
            mergedType = ((JsonListType)type1).merge((JsonListType)type2);
        }
        if (mergedType != null) {
            return mergedType;
        }
        throw new RuntimeException("Incompatible types: " + type1.getName() + " vs: " + type2.getName());
    }
}

