/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.json;

import gw.lang.reflect.json.IJsonParser;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class NashornJsonParser
implements IJsonParser {
    private static final NashornJsonParser INSTANCE = new NashornJsonParser();
    private ScriptEngine _engine;

    public static IJsonParser instance() {
        return INSTANCE;
    }

    private NashornJsonParser() {
    }

    @Override
    public Bindings parseJson(String jsonText) throws ScriptException {
        String script;
        Object result;
        if (this._engine == null) {
            this._engine = new ScriptEngineManager().getEngineByName("javascript");
        }
        if ((result = this._engine.eval(script = "Java.asJSONCompatible(" + jsonText + ")")) instanceof Bindings) {
            return (Bindings)result;
        }
        return NashornJsonParser.wrapValueInBindings(result);
    }

    static Bindings wrapValueInBindings(Object result) throws ScriptException {
        if (result == null || result instanceof List || result instanceof String || result instanceof Number || result instanceof Boolean) {
            SimpleBindings wrapper = new SimpleBindings();
            wrapper.put("value", result);
            return wrapper;
        }
        throw new ScriptException("Unexpected JSON result type: " + result.getClass().getName());
    }
}

