/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.fs.IFile;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.module.IModule;

public class RefreshRequest {
    public final IFile file;
    public final IModule module;
    public final ITypeLoader typeLoader;
    public final RefreshKind kind;
    public final String[] types;

    public RefreshRequest(IFile file, String[] types, IModule module, ITypeLoader typeLoader, RefreshKind kind) {
        this.file = file;
        this.kind = kind;
        this.types = types;
        this.module = module;
        this.typeLoader = typeLoader;
    }

    public RefreshRequest(IFile file, String[] types, ITypeLoader typeLoader, RefreshKind kind) {
        this(file, types, RefreshRequest.getModule(typeLoader), typeLoader, kind);
    }

    public RefreshRequest(String[] allTypes, RefreshRequest request, ITypeLoader typeLoader) {
        this(request.file, allTypes, typeLoader, request.kind);
    }

    public RefreshRequest(IFile file, String[] types, IModule module, RefreshKind kind) {
        this(file, types, RefreshRequest.getLoader(file, module), kind);
    }

    private static ITypeLoader getLoader(IFile file, IModule module) {
        for (ITypeLoader loader : module.getModuleTypeLoader().getTypeLoaderStack()) {
            if (!loader.handlesFile(file)) continue;
            return loader;
        }
        throw new RuntimeException("No type loader for file: " + file);
    }

    private static IModule getModule(ITypeLoader typeLoader) {
        if (typeLoader == null) {
            throw new RuntimeException("A refresh request must have a valid typeloader");
        }
        return typeLoader.getModule();
    }

    public String toString() {
        String s = this.kind + " of ";
        for (String type : this.types) {
            s = s + type + ", ";
        }
        s = s + "from " + (this.typeLoader != null ? this.typeLoader : this.module);
        return s;
    }
}

