/*
 * Decompiled with CFR 0.152.
 */
package gw.config;

import gw.config.CommonServices;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.util.ILogger;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TypeLoaderSpec {
    String _typeloaderClassName = null;
    HashMap _additionalArgs = new HashMap();

    public TypeLoaderSpec(Node xmlNode, URL registryUrl) {
        NamedNodeMap map = xmlNode.getAttributes();
        for (int length = map.getLength() - 1; length >= 0; --length) {
            Node node = map.item(length);
            if (node.getNodeName().equals("class")) {
                this._typeloaderClassName = node.getNodeValue();
                continue;
            }
            if (node.getNodeName().equals("src")) {
                try {
                    File file = new File(registryUrl.toURI()).getParentFile();
                    file = new File(file, node.getNodeValue()).getCanonicalFile();
                    this._additionalArgs.put(node.getNodeName(), file.getAbsolutePath());
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this._additionalArgs.put(node.getNodeName(), node.getNodeValue());
        }
    }

    public String getTypeloaderClassName() {
        return this._typeloaderClassName;
    }

    public HashMap getAdditionalArgs() {
        return this._additionalArgs;
    }

    public ITypeLoader createTypeLoader(IExecutionEnvironment execEnv) {
        return TypeLoaderSpec.createTypeLoader(execEnv, this._typeloaderClassName, this._additionalArgs);
    }

    public static ITypeLoader createTypeLoader(IExecutionEnvironment execEnv, String typeloaderClassName, HashMap additionalArgs) {
        ILogger logger = CommonServices.getEntityAccess().getLogger();
        ITypeLoader additionalTypeLoader = null;
        boolean gosu = false;
        try {
            Class<?> clazz = execEnv.getClass().getClassLoader().loadClass(typeloaderClassName);
            Constructor constructor = TypeLoaderSpec.getConstructor(clazz, IExecutionEnvironment.class, Map.class);
            if (constructor != null) {
                additionalTypeLoader = (ITypeLoader)constructor.newInstance(execEnv, additionalArgs);
            } else {
                constructor = TypeLoaderSpec.getConstructor(clazz, IExecutionEnvironment.class);
                if (constructor != null) {
                    additionalTypeLoader = (ITypeLoader)constructor.newInstance(execEnv);
                } else {
                    constructor = TypeLoaderSpec.getConstructor(clazz, new Class[0]);
                    if (constructor != null) {
                        additionalTypeLoader = (ITypeLoader)constructor.newInstance(new Object[0]);
                    } else {
                        logger.error("The type loader " + typeloaderClassName + " does not have a callable constructor.  It must provide\na constructor that takes either (IExecutionEnvironment, Map), (IExecutionEnvironment) or no paramters");
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                IType type = TypeSystem.getByFullName(typeloaderClassName);
                gosu = true;
                IConstructorInfo constructor = TypeLoaderSpec.getConstructor(type, JavaTypes.IEXECUTION_ENVIRONMENT(), JavaTypes.MAP());
                if (constructor != null) {
                    additionalTypeLoader = (ITypeLoader)constructor.getConstructor().newInstance(execEnv, additionalArgs);
                } else {
                    constructor = TypeLoaderSpec.getConstructor(type, JavaTypes.IEXECUTION_ENVIRONMENT());
                    if (constructor != null) {
                        additionalTypeLoader = (ITypeLoader)constructor.getConstructor().newInstance(execEnv);
                    } else {
                        constructor = TypeLoaderSpec.getConstructor(type, new IType[0]);
                        if (constructor != null) {
                            additionalTypeLoader = (ITypeLoader)constructor.getConstructor().newInstance(new Object[0]);
                        } else {
                            logger.error("The type loader " + typeloaderClassName + " does not have a callable constructor.  It must provide\na constructor that takes either (IExecutionEnvironment, Map), (IExecutionEnvironment) or no paramters");
                        }
                    }
                }
            }
            catch (Exception e2) {
                logger.error("Unable to load type loader " + typeloaderClassName, gosu ? e2 : e);
                return null;
            }
        }
        return additionalTypeLoader;
    }

    private static Constructor getConstructor(Class clazz, Class ... argTypes) {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static IConstructorInfo getConstructor(IType type, IType ... argTypes) {
        return type.getTypeInfo().getConstructor(argTypes);
    }
}

