/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import java.lang.module.ModuleDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.LinkedHashSet;

public class ClasspathUtil {
    private static final String MANIFEST = "META-INF/MANIFEST.MF";

    public static URL[] of(ClassLoader classLoader, Class clazz) {
        if (clazz == null) {
            clazz = ClasspathUtil.class;
        }
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        while (classLoader != null) {
            ModuleDescriptor moduleDescriptor;
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                URL[] allURLS = urlClassLoader.getURLs();
                Collections.addAll(urls, allURLS);
                break;
            }
            URL classUrl = ClasspathUtil.classModuleUrl(classLoader, clazz);
            if (classUrl != null) {
                urls.add(classUrl);
            }
            if ((classUrl = ClasspathUtil.classModuleUrl(classLoader, ClasspathUtil.class)) != null) {
                urls.add(classUrl);
            }
            if ((moduleDescriptor = clazz.getModule().getDescriptor()) != null) {
                moduleDescriptor.requires().forEach(req -> ModuleLayer.boot().findModule(req.name()).ifPresent(mod -> {
                    URL url;
                    ClassLoader moduleClassLoader = mod.getClassLoader();
                    if (moduleClassLoader != null && (url = moduleClassLoader.getResource(MANIFEST)) != null) {
                        url = ClasspathUtil.fixManifestUrl(url);
                        urls.add(url);
                    }
                }));
            }
            classLoader = classLoader.getParent();
        }
        return urls.toArray(new URL[0]);
    }

    private static URL fixManifestUrl(URL url) {
        Object urlString = url.toString();
        int ndx = ((String)urlString).indexOf(MANIFEST);
        urlString = ((String)urlString).substring(0, ndx) + ((String)urlString).substring(ndx + MANIFEST.length());
        try {
            return new URL((String)urlString);
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }

    private static URL classModuleUrl(ClassLoader classLoader, Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName().replace('.', '/') + ".class";
        return ClasspathUtil.resourceModuleUrl(classLoader, name);
    }

    private static URL resourceModuleUrl(ClassLoader classLoader, String resourceClassPath) {
        URL url = classLoader.getResource(resourceClassPath);
        if (url == null) {
            return null;
        }
        Object urlString = url.toString();
        int ndx = ((String)urlString).indexOf(resourceClassPath);
        urlString = ((String)urlString).substring(0, ndx) + ((String)urlString).substring(ndx + resourceClassPath.length());
        try {
            return new URL((String)urlString);
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }
}

