/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.builder;

import gw.lang.GosuShop;
import gw.lang.UnstableAPI;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRCastExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UnstableAPI
public class IRArgConverter {
    public static IRExpression castOrConvertIfNecessary(IRType expectedType, IRExpression root) {
        IRType rootType = root.getType();
        if (expectedType.isPrimitive()) {
            if (!rootType.isPrimitive()) {
                IRType boxedType = IRArgConverter.getBoxedType(expectedType);
                if (!boxedType.equals(root.getType())) {
                    root = IRArgConverter.cast(root, boxedType);
                }
                root = IRArgConverter.unbox(root);
            }
        } else if (rootType.isPrimitive()) {
            root = IRArgConverter.box(root);
        } else if (!expectedType.isAssignableFrom(rootType)) {
            root = IRArgConverter.cast(root, expectedType);
        }
        return root;
    }

    public static IRType getBoxedType(Class returnType) {
        return IRArgConverter.getBoxedType(IRArgConverter.getIRType(returnType));
    }

    public static IRType getBoxedType(IRType returnType) {
        if (returnType.isBoolean()) {
            return IRArgConverter.getIRType(Boolean.class);
        }
        if (returnType.isByte()) {
            return IRArgConverter.getIRType(Byte.class);
        }
        if (returnType.isChar()) {
            return IRArgConverter.getIRType(Character.class);
        }
        if (returnType.isDouble()) {
            return IRArgConverter.getIRType(Double.class);
        }
        if (returnType.isFloat()) {
            return IRArgConverter.getIRType(Float.class);
        }
        if (returnType.isInt()) {
            return IRArgConverter.getIRType(Integer.class);
        }
        if (returnType.isLong()) {
            return IRArgConverter.getIRType(Long.class);
        }
        if (returnType.isShort()) {
            return IRArgConverter.getIRType(Short.class);
        }
        throw new IllegalArgumentException("Type " + returnType.getName() + " is not a primitive class");
    }

    public static IRMethodCallExpression unbox(IRExpression root) {
        IRType rootType = root.getType();
        if (rootType.equals(IRArgConverter.getIRType(Boolean.class))) {
            return IRArgConverter.call(root, Boolean.class, "booleanValue");
        }
        if (rootType.equals(IRArgConverter.getIRType(Byte.class))) {
            return IRArgConverter.call(root, Byte.class, "byteValue");
        }
        if (rootType.equals(IRArgConverter.getIRType(Character.class))) {
            return IRArgConverter.call(root, Character.class, "charValue");
        }
        if (rootType.equals(IRArgConverter.getIRType(Double.class))) {
            return IRArgConverter.call(root, Double.class, "doubleValue");
        }
        if (rootType.equals(IRArgConverter.getIRType(Float.class))) {
            return IRArgConverter.call(root, Float.class, "floatValue");
        }
        if (rootType.equals(IRArgConverter.getIRType(Integer.class))) {
            return IRArgConverter.call(root, Integer.class, "intValue");
        }
        if (rootType.equals(IRArgConverter.getIRType(Long.class))) {
            return IRArgConverter.call(root, Long.class, "longValue");
        }
        if (rootType.equals(IRArgConverter.getIRType(Short.class))) {
            return IRArgConverter.call(root, Short.class, "shortValue");
        }
        throw new IllegalArgumentException("Type " + rootType.getName() + " is not a boxed type");
    }

    public static IRMethodCallExpression box(IRExpression root) {
        IRType rootType = root.getType();
        if (rootType.isBoolean()) {
            return IRArgConverter.call(null, Boolean.class, "valueOf", new Class[]{Boolean.TYPE}, root);
        }
        if (rootType.isByte()) {
            return IRArgConverter.call(null, Byte.class, "valueOf", new Class[]{Byte.TYPE}, root);
        }
        if (rootType.isChar()) {
            return IRArgConverter.call(null, IRArgConverter.class, "valueOf", new Class[]{Character.TYPE}, root);
        }
        if (rootType.isDouble()) {
            return IRArgConverter.call(null, Double.class, "valueOf", new Class[]{Double.TYPE}, root);
        }
        if (rootType.isFloat()) {
            return IRArgConverter.call(null, Float.class, "valueOf", new Class[]{Float.TYPE}, root);
        }
        if (rootType.isInt()) {
            return IRArgConverter.call(null, Integer.class, "valueOf", new Class[]{Integer.TYPE}, root);
        }
        if (rootType.isLong()) {
            return IRArgConverter.call(null, Long.class, "valueOf", new Class[]{Long.TYPE}, root);
        }
        if (rootType.isShort()) {
            return IRArgConverter.call(null, Short.class, "valueOf", new Class[]{Short.TYPE}, root);
        }
        throw new IllegalArgumentException("Type " + rootType.getName() + " is not a primitive class");
    }

    public static Character valueOf(char c) {
        if (c >= '\u0000' && c <= '\u007f') {
            return Character.valueOf(c);
        }
        return new Character(c);
    }

    public static IRCastExpression cast(IRExpression root, IRType type) {
        return new IRCastExpression(root, type);
    }

    private static IRMethodCallExpression call(IRExpression root, Class rootClass, String methodName) {
        return IRArgConverter.call(root, rootClass, methodName, new Class[0], new IRExpression[0]);
    }

    private static IRMethodCallExpression call(IRExpression root, Class rootClass, String methodName, Class[] argTypes, IRExpression ... args) {
        try {
            Method method = rootClass.getMethod(methodName, argTypes);
            return new IRMethodCallExpression(methodName, IRArgConverter.getIRType(rootClass), false, IRArgConverter.getIRType(method.getReturnType()), IRArgConverter.getIRTypes(method.getParameterTypes()), root, Arrays.asList(args));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static IRType getIRType(Class cls) {
        return GosuShop.getIRTypeResolver().getDescriptor(cls);
    }

    private static List<IRType> getIRTypes(Class[] classes) {
        ArrayList<IRType> results = new ArrayList<IRType>();
        for (Class cls : classes) {
            results.add(IRArgConverter.getIRType(cls));
        }
        return results;
    }
}

